/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

import opale.mathtools.*;
import opale.matrix.*;
import opale.matrix.solver.*;


public class SymCrout
{
public static void main(String[] arg)
	{
	SymMatrix A = new SymMatrix (100);
	DVect b = new DVect(100);
	DVect x = new DVect(100);
	
	for (int i=0;i<100;i++)
		{
		b.set(i,Math.random()*100);
		A.set(i,i,2);
		if (i>0) A.set(i,i-1,-1);
//		for(int j = 0;j <i;j++)
//			A.set(i,j,Math.random()*100);
		 }
	System.out.println(A);
	SymMatrix AA=(SymMatrix) A.clone();	 
	SolverCrout ch = new SolverCrout();
	ch.decomp(A);
	ch.solve(null,b,x);

	
	
	DVect err = new DVect(100);
	DVect Ax = new DVect(100);
	Ax = AA.mul(x);
	for (int i=0;i<100;i++)
		{
		err.set(i,Ax.get(i)-b.get(i));
		}
	
	System.out.println("Err = "+err.getMax());
	
	}
	
}
