/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.tools;

import java.io.*;


/**
* Many classes of Opale extend this abstract class. It makes it possible to read/write in a stream with an user language.
* @author O.C.
* @since Opale-tools 0.14 (OpaleV1b5)
*/
public abstract class OpaleObject  implements Cloneable
{
private static OpaleSet global_set = new OpaleSet();
private String id=null;
//public static  int PRECEDENCE ;
//protected static void cleanGlobalSet() { global_set.clear();}


protected OpaleObject()
	{
	if (Debug.On) Debug.print("New OpaleObject : "+this.getClass().getName());
	}

/**
* Return the string identifcator of this object.
* @return String, the id.
*/
public final String getId() { return id;}

/**
* Set the id of this object. It's not possible to set an id if the object has already an id : in this case this method return -1. Moreover if the id exists, an instance of <code>opale.tools.InvalidIdException</code> is thrown. In other case it returns a positive integer. 
* @param String, the id.
* @return int, the return code 
*/
public final int setId(String i)
        {
        if (id == null)
                {
              //  if (global_set.contains(i)) throw new InvalidIdException("This id "+i+" already exists !!!");
               // else
                        {
                        this.id = i;
                        global_set.add(this);
                        if (Debug.On) global_set.check();
			}
                return 1;
		}
       // else throw new InvalidIdException("This OpaleObject "+this+" has already an identificator !!!");
        else 
		{
		if (Debug.On) Debug.print("This Opale object  "+this+" has already an identificator !!! Its id is not changed : "+this.getId());
		return -1;
		}
	}

/**
* This method read the data in a file at format '.opa' . It calls the abstract method <code>readKeyword</code> implemented in the derivated classes.
* @param StreamReader f, stream to read.
* @param OpaleSet session, the group of object that are read in the stream.
*/
public void read( StreamReader f,OpaleSet session)  throws java.io.IOException,InvalidFormatException
	{
	int type;
	String sval = f.next();	//on lit la premiere '{'
	if (  !sval.equals("{") ) throw new InvalidFormatException("Stream of data  non valid !!");
	//	if (Debug.On) Debug.print("bonjour = "+sval);
	while ( !((sval = f.next()).equals("}")))
		{
	//	if (Debug.On) Debug.print("key = "+sval);
		if (readKeyWord(sval,f,session) == -1) throw new InvalidFormatException("Stream of data non valid : error reading the keyword "+sval+" !!");
		}
	//	if (Debug.On) Debug.print("end = "+sval);
	
	}

/**
* method to read a key word in a file. To be overriden if necessary.
* @param String s, key word to read.
* @param StreamReader, stream to read.
* @param OpaleSet session,  the group of 'Opale' object
* @return int, 0 if the key word is correct, -1 otherwise.
*/
public  int readKeyWord(String s, StreamReader f,OpaleSet session)  throws java.io.IOException, InvalidFormatException 
{ 
return -1;
}

/**
* Abstract method to write the current object in a stream.
* @param printWriter f, a stream.
* @param OpaleSet session,   the set of 'Opale' object. 
*/
public abstract void write(PrintWriter f, OpaleSet session) throws InvalidFormatException ;

/**
* Return a "clone object" but with an id set at null pointer. 
* @return Object
*/
public Object clone()
	{
	try
		{
		OpaleObject copy =  (OpaleObject) super.clone();
		copy.id=null;
		return copy;
		}
	catch (CloneNotSupportedException e) // ne devrait jamais arriver
		{
		throw new InternalError();
		}
	}

}
