/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.mathtools.parser;


class PNode extends Object {
        public static final int NULL     = -1;
        public static final int OP          = 0;
        public static final int VALUE       = 1;
        public static final int FUNCTION   = 2;
        public static final int VAR = 3;
        public static final int PARAMETER   = 4;
        
        PNode left;
        PNode right;
        double value;
        int op;
        int type;
        String svalue;
  
        
        public PNode() {
            type = NULL;
            left = null;
            right = null;
            op = NULL;
            value = 0.0;
	    svalue="";
        } 
        
         public PNode(PNode n) {
            replace(n);
         }

         public void replace(PNode n ) {
            if(n == null) return;
            op          = n.op;
            type        = n.type;
            left        = n.left;
            right       = n.right;
            value       = n.value;
            svalue       = new String(n.svalue);
        }

         public void indent(int ind) {
              for (int i = 0; i < ind; i++) System.out.print(" ");
        }

        public void print(int indentLevel) {
           char l[] = new char[1];
           indent(indentLevel);
           System.out.println("NODE type=" + type);
           indent(indentLevel);
           switch (type) {
              case PNode.VALUE:
                 System.out.println("     value=" + value);
                 break;
              case PNode.FUNCTION:
                 System.out.println("     svalue=" + svalue);
                 break;
              case PNode.VAR:
                 System.out.println("     variable=" + svalue);
                 break;
              default:
                 System.out.println("     op=" + (char)op);
                 if(left  != null) left.print(indentLevel + 5);
                 if(right != null) right.print(indentLevel + 5);
                 break;
           }
        }
         
}
