/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */




package opale.m2d;
import java.awt.*;

/**
* Cette classe modelise un systme de coordonnes utilisateur 2D cartsien. Elle tend la classe de base de tous les systmes de coordonnes <code> CoordSystem</code>.
* @author OC
* @since Opale-2d 0.1
*/

public class LinLinCS extends CoordSystem
{
private double stepX,stepY; //pas sur les axes
private double originX, originY;	// les coordonnes du centre

/**
* Constructeur du systme de coordonnes  partir des dimensions de la future fenetre d'affichage.
* @param int x, y les coordonnes du coin suprieur gauche.
* @param int w,h la largeur et la hauteur.
*/
public LinLinCS(int x, int y, int w, int h)
	{
	setSize(x,y,w,h);
	try
	{
	oij = new OIJ(0,0,1,0,0,1);
	autoadjust();
	}
	catch(OIJException e)
	{}
	}

/**
* Constructeur du systme de coordonnes  partir des dimensions de la future fenetre d'affichage, et d'un repre OIJ.
* @param OIJ oij, le repre  attacher au systme de coordonnes.
* @param int x, y les coordonnes du coin suprieur gauche.
* @param int w,h la largeur et la hauteur.
*/
public LinLinCS(OIJ oij,int x, int y, int w, int h)
	{
	setSize(x,y,w,h);
	setOIJ(oij);
	autoadjust();
	}


public void autoadjust()
	{
	final double normI = Math.sqrt(oij.normSqI());
	final double normJ = Math.sqrt(oij.normSqJ());
	stepX=width/(xmax-xmin)/normI;
	stepY=height/(ymax-ymin)/normJ;

	originX=(int) (borderX-xmin*stepX*normI);
	originY=(int) (borderY+ymax*stepY*normJ);
	}

public void normadjust()
	{
	final double normI = Math.sqrt(oij.normSqI());
	final double normJ = Math.sqrt(oij.normSqJ());
	stepX=stepY = Math.min(width/(xmax-xmin)/normI,height/(ymax-ymin)/normJ);

	width = (int) ((xmax-xmin)*stepX*normI);
	height = (int) ((ymax-ymin)*stepX*normJ);
	
	originX=(int) (borderX-xmin*stepX*normI);
	originY=(int) (borderY+ymax*stepY*normJ);
	}
	
public final int X(double x, double y)
	{
	return (int) (originX+x*stepX*oij.getIx()+y*stepY*oij.getJx());
	}

public final int Y(double x, double y)
	{
	return (int) (originY-x*stepX*oij.getIy()-y*stepY*oij.getJy());
	}

public final double xfromXY(int X, int Y)
	{
	return (double) oij.getOriginX() + ((X-originX)*oij.getJy()-(Y-originY)*oij.getJx())/(stepX*(oij.getIx()*oij.getJy()-oij.getIy()*oij.getJx()));
	}

public final double yfromXY(int X, int Y)
	{
	return (double) oij.getOriginY() + ((Y-originY)*oij.getIx()-(X-originX)*oij.getIy())/(stepY*(-oij.getIx()*oij.getJy()+oij.getIy()*oij.getJx()));
	}

public final double normSq(double x, double y)
	{
	return oij.normSq(x,y);
	}


	
}