/*
 * Decompiled with CFR 0.152.
 */
package opale.matrix.solver;

import opale.mathtools.DVect;
import opale.matrix.BandDecomposition;
import opale.matrix.BandMatrix;
import opale.matrix.Matrix;
import opale.matrix.Solver;

public class SolverLUBand
implements Solver,
BandDecomposition {
    private BandMatrix MatLU;
    private int[] pivot;
    private int signepermut;

    public void decomp(BandMatrix bandMatrix) {
        int n = bandMatrix.getSize();
        int n2 = (bandMatrix.getSizeOfBand() - 1) / 2;
        this.pivot = new int[n];
        this.signepermut = 1;
        this.MatLU = bandMatrix;
        double[] dArray = this.MatLU.getInternalArray();
        int n3 = 0;
        while (n3 < n) {
            this.pivot[n3] = n3;
            ++n3;
        }
        int n4 = 0;
        while (n4 < n - 1) {
            double d = Math.abs(dArray[bandMatrix.getPosition(this.pivot[n4], n4)]);
            int n5 = n4;
            int n6 = Math.max(0, n4 - n2);
            int n7 = Math.min(n - 1, n4 + n2);
            double d2 = 1.0 / dArray[bandMatrix.getPosition(this.pivot[n4], n4)];
            n7 = Math.min(n - 1, this.pivot[n4] + n2);
            int n8 = n4 + 1;
            while (n8 <= n7) {
                double d3;
                dArray[bandMatrix.getPosition((int)this.pivot[n8], (int)n4)] = d3 = dArray[bandMatrix.getPosition(this.pivot[n8], n4)] * d2;
                int n9 = n4 + 1;
                while (n9 <= n7) {
                    dArray[bandMatrix.getPosition((int)this.pivot[n8], (int)n9)] = dArray[bandMatrix.getPosition(this.pivot[n8], n9)] - d3 * dArray[bandMatrix.getPosition(this.pivot[n4], n9)];
                    ++n9;
                }
                ++n8;
            }
            ++n4;
        }
    }

    public double determinant() {
        double d = this.signepermut;
        int n = this.MatLU.getSizeOfBand();
        int n2 = this.MatLU.getSize();
        double[] dArray = this.MatLU.getInternalArray();
        int n3 = 0;
        while (n3 < n2) {
            d *= dArray[n3 * n + (n - 1) / 2];
            ++n3;
        }
        return d;
    }

    public void solve(Matrix matrix, DVect dVect, DVect dVect2) {
        int n;
        int n2 = this.MatLU.getSize();
        double[] dArray = this.MatLU.getInternalArray();
        int n3 = (this.MatLU.getSizeOfBand() - 1) / 2;
        if (n2 != dVect.size() || n2 != dVect2.size()) {
            throw new IllegalArgumentException("matrix and vector dimension are not equals.");
        }
        double[] dArray2 = dVect.toArray();
        double[] dArray3 = dVect2.toArray();
        int n4 = 0;
        while (n4 < n2) {
            double d = 0.0;
            int n5 = n = Math.max(0, n4 - n3);
            while (n5 < n4) {
                d += dArray[this.MatLU.getPosition(this.pivot[n4], n5)] * dArray3[n5];
                ++n5;
            }
            dArray3[n4] = dArray2[this.pivot[n4]] - d;
            ++n4;
        }
        int n6 = n2 - 1;
        while (n6 >= 0) {
            double d = 0.0;
            n = Math.min(n2 - 1, n6 + n3);
            int n7 = n6 + 1;
            while (n7 <= n) {
                d += dArray[this.MatLU.getPosition(this.pivot[n6], n7)] * dArray3[n7];
                ++n7;
            }
            dArray3[n6] = (dArray3[n6] - d) / dArray[this.MatLU.getPosition(this.pivot[n6], n6)];
            --n6;
        }
    }

    public static void main(String[] stringArray) {
        int n = 6;
        BandMatrix bandMatrix = new BandMatrix(n, 3);
        int n2 = 0;
        while (n2 < n) {
            bandMatrix.set(n2, n2, 2.0);
            if (n2 > 0) {
                bandMatrix.set(n2, n2 - 1, -7.0);
            }
            if (n2 < n - 1) {
                bandMatrix.set(n2, n2 + 1, -1.0);
            }
            ++n2;
        }
        System.out.println(bandMatrix);
        DVect dVect = new DVect(6);
        DVect dVect2 = new DVect(6);
        dVect.set(0, 1.0);
        dVect.set(1, 0.0);
        SolverLUBand solverLUBand = new SolverLUBand();
        solverLUBand.decomp(bandMatrix);
        System.out.println(bandMatrix);
        System.out.println("det = " + solverLUBand.determinant());
        solverLUBand.solve(null, dVect, dVect2);
        System.out.println(dVect2);
    }
}

