/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.ode.scheme;

import opale.mathtools.*;
import opale.ode.*;


/**
* Cette classe implmente le schma d'Heun.
* @author O.C.
* @since Opale-ODE 0.1
*/
public final class Heun extends TimeScheme
{
private double temp;
/**
* Cette mthode dfinit l'avanc en temps par la formule de Heun.
*/	
public void forward(Equation eq)
	{
	DVect tmp = new DVect(present().size());
	int i;
	for (i=0;i<present().size();i++)
		tmp.set(i,past().get(i)+dt()*der_past().get(i));
	DVect der2 = eq.derivs(time()+dt(),tmp);
	for (i=0;i<present().size();i++)
		{
		present().set(i,past().get(i)+0.5*dt()*(der_past().get(i)+der2.get(i)));

		}
	}

/**
* Cette mthode dfinit l'avanc en temps par la formule de Heun.
*/	
public void advance()
	{
	final Equation eq = getEquation();
	DVect tmp = new DVect(present().size());
	int i;
	for (i=0;i<present().size();i++)
		tmp.set(i,past().get(i)+dt()*der_past().get(i));
	DVect der2 = eq.derivs(time()+dt(),tmp);
	for (i=0;i<present().size();i++)
		{
		present().set(i,past().get(i)+0.5*dt()*(der_past().get(i)+der2.get(i)));

		}
	}

public String toString()
	{
	return "Heun";
	}

}
