/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.m2d.component2d;
import opale.m2d.*;
import opale.tools.*;
import java.util.*;



class OIJListBeans extends javax.swing.JPanel
{

private javax.swing.JComboBox list;

public OIJListBeans(OpaleSet pack)
	{
	int i;
	setLayout(new java.awt.GridLayout(1,2));
	
	add(new javax.swing.JLabel("Choix du repre : "));
	
	list = new javax.swing.JComboBox();
	//list.setMaximumRowCount(2);
	
	//System.out.println("Dans OIJListBeans : " +pack.getOIJ().size());
	Collection col = pack.objects();
	Iterator it = col.iterator();
	while (it.hasNext())
		{
		OpaleObject obj = (OpaleObject) it.next();
		if (obj instanceof OIJ)
			{
			OIJ rep = (OIJ) obj;
			list.addItem(rep);
			}
		}
	add(list,null);
	}

public OIJListBeans(OpaleSet pack, OIJ aexclure)
	{
	int i;
	setLayout(new java.awt.GridLayout(1,2));
	
	add(new javax.swing.JLabel("Choix du repre de base : "));
	
	list = new javax.swing.JComboBox();
	
	list.addItem("Repre absolu");
	Collection col = pack.objects();
	Iterator it = col.iterator();
	while (it.hasNext())
		{
		OpaleObject obj = (OpaleObject) it.next();
		if (obj instanceof OIJ)
			{
			OIJ rep = (OIJ) obj;
			if (rep != aexclure)
		     		list.addItem(rep);
			}
		}
	add(list,null);
	}
	
public OIJ getSelection()
	{
	if (list.getSelectedItem() instanceof String)
		return null;
	else
		return (OIJ) list.getSelectedItem();
	}
public void setSelection(OIJ rep)
	{
	if (rep != null)
		list.setSelectedItem(rep);
	else
		list.setSelectedItem("Repre absolu");
	}

	
}
