package odesk.ihm;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class ODeskFrame extends JFrame {
  JPanel contentPane;
  JMenuBar jMenuBar1 = new JMenuBar();
  JMenu jMenuFile = new JMenu();
  JMenuItem jMenuFileExit = new JMenuItem();
  JMenu jMenuHelp = new JMenu();
  JMenuItem jMenuHelpAbout = new JMenuItem();
  BorderLayout borderLayout1 = new BorderLayout();
  JMenu jMenuActions = new JMenu();
  JMenu jMenuPrefs = new JMenu();
  JMenuItem jMenuActionEdit = new JMenuItem();
  JMenuItem jMenuActionMkdoc = new JMenuItem();
  JMenuItem jMenuActionViewDoc = new JMenuItem();
  JMenuItem jMenuPrefEdit = new JMenuItem();
  JMenuItem jMenuPrefLoad = new JMenuItem();
  JMenuItem jMenuPrefSave = new JMenuItem();

  /**Construire le cadre*/
  public ODeskFrame() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  /**Initialiser le composant*/
  private void jbInit() throws Exception  {
    //setIconImage(Toolkit.getDefaultToolkit().createImage(ODeskFrame.class.getResource("[Votre icne]")));
    contentPane = (JPanel) this.getContentPane();
    contentPane.setLayout(borderLayout1);
    this.setSize(new Dimension(400, 300));
    this.setTitle("ODesk");
    jMenuFile.setText("Fichier");
    jMenuFileExit.setText("Quitter");
    jMenuFileExit.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuFileExit_actionPerformed(e);
      }
    });
    jMenuHelp.setText("Aide");
    jMenuHelpAbout.setText("A propos");
    jMenuHelpAbout.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuHelpAbout_actionPerformed(e);
      }
    });
    jMenuActions.setText("Actions");
    jMenuPrefs.setText("Preferences");
    jMenuActionEdit.setText("Edit File");
    jMenuActionEdit.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jMenuActionEdit_actionPerformed(e);
      }
    });
    jMenuActionMkdoc.setText("Make API doc");
    jMenuActionViewDoc.setText("View API doc");
    jMenuPrefEdit.setText("Edit ");
    jMenuPrefLoad.setText("Load ");
    jMenuPrefSave.setText("Save");
    jMenuFile.add(jMenuFileExit);
    jMenuHelp.add(jMenuHelpAbout);
    jMenuBar1.add(jMenuFile);
    jMenuBar1.add(jMenuActions);
    jMenuBar1.add(jMenuPrefs);
    jMenuBar1.add(jMenuHelp);
    jMenuActions.add(jMenuActionEdit);
    jMenuActions.addSeparator();
    jMenuActions.add(jMenuActionMkdoc);
    jMenuActions.add(jMenuActionViewDoc);
    jMenuPrefs.add(jMenuPrefEdit);
    jMenuPrefs.addSeparator();
    jMenuPrefs.add(jMenuPrefLoad);
    jMenuPrefs.add(jMenuPrefSave);
    jMenuActions.addSeparator();
    this.setJMenuBar(jMenuBar1);
  }
  /**Opration Fichier | Quitter effectue*/
  public void jMenuFileExit_actionPerformed(ActionEvent e) {
    System.exit(0);
  }
  /**Opration Aide | A propos effectue*/
  public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
    ODeskFrame_AboutBox dlg = new ODeskFrame_AboutBox(this);
    Dimension dlgSize = dlg.getPreferredSize();
    Dimension frmSize = getSize();
    Point loc = getLocation();
    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    dlg.setModal(true);
    dlg.show();
  }
  /**Remplac, ainsi nous pouvons sortir quand la fentre est ferme*/
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      jMenuFileExit_actionPerformed(null);
    }
  }

  void jMenuActionEdit_actionPerformed(ActionEvent e) {

  }
}