import opale.tools.*;
import opale.mathtools.*;
import opale.ode.*;
import opale.ode.scheme.*;


public class ee1d
	{
	
	public static void main(String[] arg)
	{
	
	Problem pb = new Problem();
	ExplicitEuler ts = new ExplicitEuler();
	pb.setEqn(
		new Equation()
			{
			DVect y = new DVect(1);
			public int dim() { return 1; }
			public DVect derivs(double t, DVect x)
				{
				y.set(0,1);
				return y;
				}
			}
		);

	pb.setTS(ts);
	pb.solve();
	
	try
	{
	WFile wf = new WFile("resu1.txt");
	pb.writeSol(wf);
	wf.writeln("");
	wf.close();
	}
	catch(java.io.IOException e)
	{}	


	// resolution de y'=y, y(0)=1 (sol exacte exp(t))
	pb.setEqn(
		new Equation()
			{
			public int dim() { return 1; }
			public DVect derivs(double t, DVect x)
				{
				return x;
				}
			}
		);
	
	DVect cd = new DVect(1);
	cd.set(0,1);
	pb.setInit(cd);
	pb.solve();
	
	try
	{
	WFile wf = new WFile("resu2.txt");
	pb.writeSol(wf);
	wf.writeln("");
	wf.close();
	}
	catch(java.io.IOException e)
	{}	
	
	// resolution de y'=-2*ty, y(0)=1 (sol exacte 1/(1+t))
	pb.setEqn(
		new Equation()
			{
			DVect y = new DVect(1);
			public int dim() { return 1; }
			public DVect derivs(double t, DVect x)
				{
				y.set(0,-2*t*x.get(0)*x.get(0));
				return y;
				}
			}
		);
	
	cd.set(0,0.5);
	ts.set(-1,1);
	pb.setInit(cd);
	pb.solve();
	
	try
	{
	WFile wf = new WFile("resu3.txt");
	pb.writeSol(wf);
	wf.writeln("");
	wf.close();
	}
	catch(java.io.IOException e)
	{}	
	
	// resolution de y'=2*ty, y(0)=1 (sol exacte 1/(1-t))
	pb.setEqn(
		new Equation()
			{
			DVect y = new DVect(1);
			public int dim() { return 1; }
			public DVect derivs(double t, DVect x)
				{
				y.set(0,2*t*x.get(0)*x.get(0));
				return y;
				}
			}
		);
	
	cd.set(0,1);
	ts.setNstep(5000);
	ts.set(0,0.9);
	pb.setInit(cd);
	pb.solve();
	
	try
	{
	WFile wf = new WFile("resu4.txt");
	pb.writeSol(wf);
	wf.writeln("");
	wf.close();
	}
	catch(java.io.IOException e)
	{}	
	
	// resolution de y'=-y, y(0)=1 (sol exacte 1/(1+t))
	pb.setEqn(
		new Equation()
			{
			DVect y = new DVect(1);
			public int dim() { return 1; }
			public DVect derivs(double t, DVect x)
				{
				y.set(0,-x.get(0)*x.get(0));
				return y;
				}
			}
		);
	
	cd.set(0,1);
	ts.setNstep(100);
	ts.set(0,10);
	pb.setInit(cd);
	pb.solve();
	
	try
	{
	WFile wf = new WFile("resu5.txt");
	pb.writeSol(wf);
	wf.writeln("");
	wf.close();
	}
	catch(java.io.IOException e)
	{}		
	}

}
