/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/
package opale.ode;
import opale.mathtools.DVect;

/**
* This interface muste be implemented to define an equation for a ODE problem : (xi)'=f(t,x1,...,xn) for i=1 to n. Two methods are abstracts : 
* <UL> 
* <LI> the method <code>dim()</code> that returns the dimension of teh equation, i.e. the  number of unknown 'n').
* <LI> the method <code>double[] deriv(double t, double[] x)</code> that defines the function f of th problem.
* </UL>
* @since Opale-ODE 0.1
* @author O.C.
*/

public interface Equation
{
/**
* Get the space dimension of the unknown.
* @return int, the dimension.
*/
public int dim();

/**
* Defines the function of the equation.
* @param double t, time parameter (=derivation parameter).
* @param DVect x, unknown parameters.
* @return DVect, the value of the function at the point (t,x).
*/
public DVect derivs(double t, DVect x);
}
