/** 
* This abstract class must be extended to perform a linear system solver, for instance Jacobi's method, LU...
* @author O.C.
* @date 04/2001
*/

public abstract class Solver
{
/**
* Solve Ax=b
*/
public void solve(Matrix A, DVect b, DVect x);


}

/** 
* This interface must be implemented by classes that define decomposition method, for instance LU, Cholesky... A class can be implemented both <code>Solver</code> and <code>Decomposition</code>.
* @author O.C.
* @date 04/2001
*/

public interface Decomposition
{
/**
* Decompose the matrix A.
*/
public void decomp(Matrix A);
}

