package opale.module2d.noyau2d;
import java.awt.*;
/* Cette calsse permet d'effctuer des calculs de statistiques de base
* sur un echantillon de donnes.
*auteur K.D.
*version 0.1*/


class Stat {
    int dim;
    double x[];

// consutructeur par dfaut qui initialise le tableau par des O.
public Stat(int dim){
    double[] x = new double[dim];
    for(int i=0;i<dim;i++)
      x[i]=0;
    }

// constructeur  partir d'un echantillon existant.
public Stat(Stat M){
   this.dim = M.dim;
   double[] x = new double[M.dim];
   for(int i=0;i<this.dim;i++)
     this.x[i] = M.x[i];
   }

// constructeur  partir d'un tableau de donnes.
public Stat(double y[], int length){
    dim = length;
    for(int i=0;i<dim;i++)
      x[i] = y[i];
    }

// cette fonction calcul la moyenne d'une population.
// indice de tendances central.
public double average(){
    double avg = 0;
    for(int i=0;i<this.dim;i++)
      avg += avg + this.x[i];
    avg = avg/this.dim;
    return avg;
    }

// cette fonction calcul la variance d'une population.
// indice de la dispersion d'une population.
// les lments reprsentent la population entire.
public double variance(){
    double vary = 0;
    for(int i=0;i<this.dim;i++)
      vary += Math.pow(this.x[i] - this.average(),2);
    vary = vary / this.dim;
    return vary;
    }
// cette fonction calcul la varaince d'un chantillon
// d'une population  l'aide de l'estimateur sans biais.
public double variance_ech(){
    double vary;
    int n = this.dim;
    vary = (n / (n - 1)) * this.variance();
    return vary;
    }

// cette fonction calcul l'cart-type.
public double ecartype(){
    double ecart;
    ecart = Math.sqrt(this.variance());
    return ecart;
    }

// cette fonction renvoie l'cart-type d'un chantillon.
public double ecartype_ech(){
    double ecart;
    ecart = Math.sqrt(this.variance_ech());
    return ecart;
    }
    

// cette fonction calcul la covariance.
// il reprsente le degr de dissociation entre deux population.
// les deux populations doivent la mme dimension.
public double covariance(Stat M){
    double cov = 0;
    for(int i=0;i<M.dim;i++)
      cov += (this.x[i] - this.average())*(M.x[i] - M.average());
    cov = cov / M.dim;
    return cov;
    }

// cette fonction calcul la corrlation.
// elle resemble  la covaiance mais elle comprisent entre -1 et 1.
public double correlation(Stat M){
    double cor;
    cor = this.covariance(M) / (this.ecartype() * M.ecartype());
    return cor;
    }

}



