/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.mathtools;

/**
* Thrown when an exceptional condition has occurred finding a root. For 
* example, if the method doesn't converge then it throws an 
* instance of this class. 
* @author  O.C.
* @date 01/2001
* @since Opale-Mathtools 0.11
*/
public class RootFinderException extends RuntimeException {
    /**
     * Constructs an <code>RootFinderException</code> with no detail 
     * message. 
     */
    public RootFinderException() {
	super();
    }

    /**
     * Constructs an <code>RootFinderException</code> with the specified 
     * detail message. 
     *
     * @param   s   the detail message.
     */
    public RootFinderException(String s) {
	super(s);
    }
}
