/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.mathtools;


public abstract class FSolve
{
protected double eps = 1.e-10;
protected int Nmax = 100;

public int getNmax()
	{
	return Nmax;
	}

public void setNmax(int n)
	{
	Nmax = Math.abs(n);
	}
	
public double getEpsilon()
	{
	return eps;
	}

public void setEpsilon(double eps)
	{
	this.eps = Math.abs(eps);
	}


abstract public void solve(IFnn f, int n,DVect x0, DVect resu);
}

class PtFixe extends FSolve
{
public void solve(IFnn f, int n, DVect x0, DVect resu)
	{
	//tester la taille de DVect avec n
	
	int i=0,sortie=0;
	double[] tab = new double[n];
	double cvg,norme;

	//initialisation des conditions initiales
	DVect x = new DVect(x0);	
	norme = x.norm2Sq();
	
	while ( (i<Nmax) && (sortie == 0) )
		{
		x.set(tab);
		resu.set(f.val(tab));
		x.sub(resu);
		cvg =   x.norm2Sq()/norme;
		
		x.set(resu);
		norme = x.norm2Sq();
		
		if ( cvg < eps ) 
			sortie = 1;
		i++;
		}
	}
	
}
