/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.mathtools;

/**
* This interface defines an abstract Polynom. 
* @author O.C.
* @date 03/2001
* @since Opale-Mathtools 0.13
*/
public abstract class AbstractPolynomial
{
/**
* Constructor by default. 
*/
public AbstractPolynomial() { opale.tools.Debug.print("Dans AbstractPolynom() ");}

/**
* Constructs a polynom of degree n initialized to zero. 
* @param int n, the degree
*/
public abstract void construct(int n);

/**
* Constructs a polynom of degree n, with the coefficients in the array tab. 
* @param int n, the degree
* @param double[] tab, the array of coefficients
*/
public abstract void construct(int n, double[] tab);

/**
* Returns the degree.
* @return int, the degree
*/
public abstract int deg();

/**
* Returns the coefficient associated with the monome x^i.
* @param int i, the coefficient to get
* @return double, the value of the coefficient
*/
public abstract double get(int i);

/**
* Sets the coefficient i with the value x.
* @param int i, the coefficient to set
* @param double x, the value
*/

public abstract void set(int i, double x);

/**
* Generic mthod to evaluate the polynom at the point x.
* @param double x, the point x
* @return double, the value of the polynom
*/
public double eval(double x)
	{
	int i;
	double y=0.;
	
	for(i=0;i<=deg();i++)
		y+=get(i)*Math.pow(x,i);
	return y;
	}

/**
* Generic mthod to print the polynom.
*/
public String toString()
	{
	String s=""+get(0);
	
	for(int i=1;i<=deg();i++)
		s+=(get(i)>0 ? " + "+get(i) : " - "+(-get(i)))+"X^"+i;
	return s;
	}

}

