/*
Copyright (C) 2000  Groupe Opale

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d.ker;

/**
* Cette classe encapsule une matrice et un vecteur de changement de repere. Elle
eest uilise avec la classe OIJ et permet une fois remplit d'obtenir les
coordonnes d'un point aprs changement de repre. Cette classe est provisoire et sera chang dans le futur.
* @version Opale 0.1
* @author O.C.
*/

public class MVPass
{
private double[][] mat;
private double[] vect;

public MVPass()
	{
	mat = new double[2][2];
	vect = new double[2];
	}

protected void set(double[][] m, double[] v)
	{
	mat[0][0] = m[0][0];
	mat[1][0] = m[1][0];
	mat[1][1] = m[1][1];
	mat[0][1] = m[0][1];
	vect[0] = v[0];
	vect[1] = v[1];
	}
	
protected void setM(int i, int j, double x)
	{
	mat[i][j] = x;
	}
	
protected void setV(int i, double x)
	{
	vect[i] = x;
	}

protected double getM(int i, int j)
	{
	return mat[i][j];
	}
	
protected double getV(int i)
	{
	return vect[i];
	}


/**
* Calcule les coordonnes du point dans le repere de dpart a partir des
coordonnes dans le repre de fin.
* @param Point2D p, le point dans le repere final.
* @return Point2D, le meme point dans le repere de dpart.
* @since Opale 0.1
*/
public Point2D compute(double xf, double yf)
	{
	double x, y;
	
	x = mat[0][0]*xf + mat[0][1]*yf + vect[0];
	y = mat[1][0]*xf + mat[1][1]*yf + vect[1];
	return new Point2D(null,x,y);
	}
	
public String toString()
	{
	return "Matrice \n"+ mat[0][0] +"\t" +mat[0][1] +"\n"+mat[1][0] +"\t"
	+mat[1][1] +"\n" + "Vecteur\n" + vect[0] +"\n" + vect[1] +"\n";
	}

 
}
	
	
