/*
Copyright (C) 2000  Groupe Opale

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d;
import opale.tools.*;
import java.io.*;

/**
* Classe contenant des informations sur les objets de type Vector2D. Elle tend la classe InfoObjet et renseigne donc sur les champs contenus dans cette dernire.
* @author O.C.
* @since Opale-2d 0.1
*/
public class InfoVector extends InfoObject implements Cloneable
{
//membres privs
protected int symbol;	//la forme de l'origine
protected int size;	//l'epaisseur de la flche
protected int symbolArrow;  //la forme de la fleche

//les constructeurs publiques
/**
* Constructeur par dfaut: symbol = 0; size = 1; symbolArrow=0
*/
public InfoVector()
	{
	super();
	symbol = 0;
	size = 5;
	symbolArrow = 0;
	}

/**
* Le constructeur de copie
* @param InfoVector inf, l'information  copier
*/
public InfoVector(InfoVector inf)
	{
	super(inf);
	symbol = inf.getSymbol();
	size = inf.getSize();
	symbolArrow = inf.getArrow();
	}


//methodes d'accs, publiques

/**
* Renvoie l'entier dfinissant la forme du point
* @return int, la forme du point 
* 0 = point
* 1 = |
* 2 = cercle
*/
public int getSymbol()
	{
	return symbol;
	}

/**
* change la forme du point
* @param int, la nouvelle forme
*/
public void setSymbol(int sym)
	{
	symbol = sym;
	}

/**
* Renvoie la taille en pixel de la fleche
* @return int, la taille 
*/
public int getSize()
	{
	return size;
	}

/**
* change la taille de la fleche
* @param int size, la nouvelle taille en pixel
*/
public void setSize(int size)
	{
	this.size = size;
	}
/**
* Renvoie l'entier dfinissant la forme de la flche.
* @return int, la forme de la flche.
* 0 = >
* 1 = |>
* 2 = |> pleine
*/
public int getArrow()
	{
	return symbolArrow;
	}

/**
* change la forme de la fleche
* @param int, la nouvelle forme
*/
public void setArrow(int sym)
	{
	symbolArrow = sym;
	}

/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	try
	{
	return (InfoVector) super.clone();
    }
	catch(InternalError e)
	{
	throw e;
	}
	}

public void writeMore(PrintWriter f, OpaleSet p)
	{
	f.println("\tSIZE " +size);
	}	
	
public  int readKeyWord(String word, StreamTokenizer f, OpaleSet p) throws java.io.IOException, InvalidFormatException
	{
	int type;
	if ( word.equals("SIZE"))
		{
		type = f.nextToken();
		if (type != StreamTokenizer.TT_NUMBER) return -1;
		size = (int) f.nval;
		return 0;
		}
	return -1;
		
	}
}
