/*
 * Decompiled with CFR 0.152.
 */
package opale.ode;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import opale.mathtools.DVect;
import opale.ode.StepsizeControl;
import opale.ode.TimeScheme;
import opale.tools.InvalidFormatException;
import opale.tools.OpaleSet;

public final class StepControl1
extends StepsizeControl {
    private double ymin;
    private double ymax;
    private double d;

    public StepControl1() {
    }

    public StepControl1(TimeScheme timeScheme) {
        super(timeScheme);
        this.ymin = 0.0;
        this.ymax = 1.0;
        this.d = 2.0;
    }

    public StepControl1(double d, double d2, double d3) {
        if (d3 < 0.0) {
            throw new IllegalArgumentException("The factor of step correction must be positive.");
        }
        this.ymin = d;
        this.ymax = d2;
        this.d = d3;
    }

    public final boolean update() {
        DVect dVect = this.getTS().present();
        int n = 0;
        while (n < dVect.size()) {
            if (dVect.get(n) > this.ymax || dVect.get(n) < this.ymin) {
                this.getTS().dt(this.getTS().dt() / this.d);
                return false;
            }
            ++n;
        }
        return true;
    }

    public int readKeyWord(String string, StreamTokenizer streamTokenizer, OpaleSet opaleSet) throws IOException, InvalidFormatException {
        if (string.equals("ymin")) {
            int n = streamTokenizer.nextToken();
            if (n != -2) {
                return -1;
            }
            this.ymin = streamTokenizer.nval;
            return 0;
        }
        if (string.equals("ymax")) {
            int n = streamTokenizer.nextToken();
            if (n != -2) {
                return -1;
            }
            this.ymax = streamTokenizer.nval;
            return 0;
        }
        if (string.equals("ratio")) {
            int n = streamTokenizer.nextToken();
            if (n != -2) {
                return -1;
            }
            this.d = streamTokenizer.nval;
            return 0;
        }
        return -1;
    }

    public void write(PrintWriter printWriter, OpaleSet opaleSet) {
        printWriter.println("{");
        printWriter.println("ymin " + this.ymin);
        printWriter.println("ymax " + this.ymax);
        printWriter.println("ratio " + this.d);
        printWriter.println("}");
    }
}

