/*
 * Decompiled with CFR 0.152.
 */
package opale.ode;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import opale.mathtools.DVect;
import opale.mathtools.parser.Parser;
import opale.ode.Equation;
import opale.ode.ObjectODE;
import opale.tools.InvalidFormatException;
import opale.tools.OpaleSet;

public class SEquation
extends ObjectODE
implements Equation {
    private int dim;
    private String[] fonc;
    private Parser[] parser;
    private double[] resu;

    public boolean setFunc(String[] stringArray) {
        if (stringArray.length < 1 || stringArray.length > 3) {
            return false;
        }
        this.dim = stringArray.length;
        this.parser = new Parser[this.dim];
        this.resu = new double[this.dim];
        this.fonc = new String[this.dim];
        int n = 0;
        while (n < this.dim) {
            this.parser[n] = new Parser();
            this.parser[n].addVar("t");
            this.parser[n].addVar("x");
            switch (this.dim) {
                case 2: {
                    this.parser[n].addVar("y");
                    break;
                }
                case 3: {
                    this.parser[n].addVar("y");
                    this.parser[n].addVar("z");
                }
            }
            this.parser[n].parseString(stringArray[n]);
            this.fonc[n] = stringArray[n];
            ++n;
        }
        return true;
    }

    public String getFunc(int n) {
        if (n >= 0 && n < 3) {
            return this.fonc[n];
        }
        return null;
    }

    public int dim() {
        return this.dim;
    }

    public DVect derivs(double d, DVect dVect) {
        this.parser[0].setVar("t", d);
        this.parser[0].setVar("x", dVect.get(0));
        switch (this.dim) {
            case 1: {
                this.resu[0] = this.parser[0].eval();
                break;
            }
            case 2: {
                this.parser[0].setVar("y", dVect.get(1));
                this.parser[1].setVar("x", dVect.get(0));
                this.parser[1].setVar("y", dVect.get(1));
                this.resu[0] = this.parser[0].eval();
                this.resu[1] = this.parser[1].eval();
                break;
            }
            case 3: {
                this.parser[0].setVar("y", dVect.get(1));
                this.parser[0].setVar("z", dVect.get(2));
                this.parser[1].setVar("x", dVect.get(0));
                this.parser[1].setVar("y", dVect.get(1));
                this.parser[1].setVar("z", dVect.get(2));
                this.parser[2].setVar("x", dVect.get(0));
                this.parser[2].setVar("y", dVect.get(1));
                this.parser[2].setVar("z", dVect.get(2));
                this.resu[0] = this.parser[0].eval();
                this.resu[1] = this.parser[1].eval();
                this.resu[2] = this.parser[2].eval();
            }
        }
        DVect dVect2 = new DVect(this.resu);
        return dVect2;
    }

    public String toString() {
        String string = "";
        if (this.dim == 1) {
            string = "f(t,x) = " + this.fonc[0];
        } else if (this.dim == 2) {
            string = "f1(t,x,y) = " + this.fonc[0] + "\n";
            string = string + "f2(t,x,y) = " + this.fonc[1];
        } else if (this.dim == 3) {
            string = "f1(t,x,y,z) = " + this.fonc[0] + "\n";
            string = string + "f2(t,x,y,z) = " + this.fonc[1] + "\n";
            string = string + "f3(t,x,y,z) = " + this.fonc[2];
        }
        return string;
    }

    public int readKeyWord(String string, StreamTokenizer streamTokenizer, OpaleSet opaleSet) throws IOException, InvalidFormatException {
        if (string.equals("f(t,x)=")) {
            this.dim = 1;
            int n = streamTokenizer.nextToken();
            if (!streamTokenizer.sval.endsWith("'") || !streamTokenizer.sval.startsWith("'")) {
                throw new InvalidFormatException("Erreur \u00e0 la lecture de la fonction  : " + streamTokenizer.sval + ". La fonction doit \u00eatre indiqu\u00e9e entre guillemets");
            }
            String[] stringArray = new String[]{streamTokenizer.sval.substring(1, streamTokenizer.sval.length() - 1)};
            if (!this.setFunc(stringArray)) {
                throw new InvalidFormatException("Erreur \u00e0 la lecture de la fonction : " + stringArray[0]);
            }
            return 0;
        }
        if (string.equals("f1(t,x,y)=")) {
            this.dim = 2;
            int n = streamTokenizer.nextToken();
            if (!streamTokenizer.sval.endsWith("'") || !streamTokenizer.sval.startsWith("'")) {
                throw new InvalidFormatException("Erreur \u00e0 la lecture de la fonction  : " + streamTokenizer.sval + ". La fonction doit \u00eatre indiqu\u00e9e entre guillemets");
            }
            String[] stringArray = new String[2];
            stringArray[0] = streamTokenizer.sval.substring(1, streamTokenizer.sval.length() - 1);
            n = streamTokenizer.nextToken();
            string = streamTokenizer.sval;
            n = streamTokenizer.nextToken();
            if (string.equals("f2(t,x,y)=")) {
                if (!streamTokenizer.sval.endsWith("'") || !streamTokenizer.sval.startsWith("'")) {
                    throw new InvalidFormatException("Erreur \u00e0 la lecture de la fonction  : " + streamTokenizer.sval + ". La fonction doit \u00eatre indiqu\u00e9e entre guillemets");
                }
            } else {
                return -1;
            }
            stringArray[1] = streamTokenizer.sval.substring(1, streamTokenizer.sval.length() - 1);
            if (!this.setFunc(stringArray)) {
                throw new InvalidFormatException("Erreur \u00e0 la lecture de la fonction");
            }
            return 0;
        }
        if (string.equals("f1(t,x,y,z)=")) {
            this.dim = 3;
            int n = streamTokenizer.nextToken();
            if (!streamTokenizer.sval.endsWith("'") || !streamTokenizer.sval.startsWith("'")) {
                throw new InvalidFormatException("Erreur \u00e0 la lecture de la fonction  : " + streamTokenizer.sval + ". La fonction doit \u00eatre indiqu\u00e9e entre guillemets");
            }
            String[] stringArray = new String[3];
            stringArray[0] = streamTokenizer.sval.substring(1, streamTokenizer.sval.length() - 1);
            n = streamTokenizer.nextToken();
            string = streamTokenizer.sval;
            n = streamTokenizer.nextToken();
            if (string.equals("f2(t,x,y,z)=")) {
                if (!streamTokenizer.sval.endsWith("'") || !streamTokenizer.sval.startsWith("'")) {
                    throw new InvalidFormatException("Erreur \u00e0 la lecture de la fonction  : " + streamTokenizer.sval + ". La fonction doit \u00eatre indiqu\u00e9e entre guillemets");
                }
            } else {
                return -1;
            }
            stringArray[1] = streamTokenizer.sval.substring(1, streamTokenizer.sval.length() - 1);
            n = streamTokenizer.nextToken();
            string = streamTokenizer.sval;
            n = streamTokenizer.nextToken();
            if (string.equals("f3(t,x,y,z)=")) {
                if (!streamTokenizer.sval.endsWith("'") || !streamTokenizer.sval.startsWith("'")) {
                    throw new InvalidFormatException("Erreur \u00e0 la lecture de la fonction  : " + streamTokenizer.sval + ". La fonction doit \u00eatre indiqu\u00e9e entre guillemets");
                }
            } else {
                return -1;
            }
            stringArray[2] = streamTokenizer.sval.substring(1, streamTokenizer.sval.length() - 1);
            if (!this.setFunc(stringArray)) {
                throw new InvalidFormatException("Erreur \u00e0 la lecture de la fonction");
            }
            return 0;
        }
        return -1;
    }

    public void write(PrintWriter printWriter, OpaleSet opaleSet) {
        printWriter.println("{");
        if (this.dim == 1) {
            printWriter.println("f(t,x)= '" + this.fonc[0] + "'");
        } else if (this.dim == 2) {
            printWriter.println("f1(t,x,y)= '" + this.fonc[0] + "'");
            printWriter.println("f2(t,x,y)= '" + this.fonc[1] + "'");
        } else if (this.dim == 3) {
            printWriter.println("f1(t,x,y,z)= '" + this.fonc[0] + "'");
            printWriter.println("f2(t,x,y,z)= '" + this.fonc[1] + "'");
            printWriter.println("f3(t,x,y,z)= '" + this.fonc[2] + "'");
        }
        printWriter.println("}");
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{3.0, 1.0, -5.0};
        DVect dVect = new DVect(dArray);
        SEquation sEquation = new SEquation();
        String[] stringArray2 = new String[]{"x*z-y-3*t", "2*x+y*z+t", "-2*x+y-z*t"};
        System.err.println(sEquation.setFunc(stringArray2));
        System.err.println(sEquation.derivs(-34.0, dVect).get(2));
        System.err.println(sEquation);
    }
}

