package opale.m2d.component2d;
import opale.m2d.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
/**
* @since Opale-2d 0.11
*/
public class JFrame2D extends JFrame  
{
private Pack2D pack;
private	CoordSystem vue;
private	GAxis2D axes;
private  JMenuBar menuBar1 = new JMenuBar();
private  JMenu menuFile = new JMenu();
private  JMenuItem menuFileExit = new JMenuItem();
private  JMenuItem menuFileClose = new JMenuItem();
private  JMenu menuEdition = new JMenu();
private  JMenuItem menuEditEchelle = new JMenuItem();
private  JMenuItem menuEditAxes = new JMenuItem();

/**
* constructeur par dfaut d'un objet de type Frame2D. La fermeture de la fenetre est gre; par dfaut elle possde une taille de 300x300.
*/
public JFrame2D()
	{
	super();
	setTitle("Opale v0.11 - JFrame 2d");
	setSize(300,300);
	super.setBackground(Color.white);

	addWindowListener(new WindowAdapter()
		{
		public void windowClosing(WindowEvent evt)
			{
			dispose();
			}
		}
		);
		
	vue = new LinLinCS(OIJ.OIJ_ABSOLUTE,0,0,300,300);
	axes = new GAxis2D(vue); axes.drawLabel(false);
	((InfoAxis) axes.getInfo()).setTick(0,1,0,1);
	
	pack = new Pack2D();
	pack.add(OIJ.OIJ_ABSOLUTE,"oij_abs");
	getContentPane().add(new DrawPanel(),"Center");	
		
	}
/**
* constructeur par dfaut d'un objet de type Frame2D. La fermeture de la fenetre est gre; par dfaut elle possde une taille de 300x300.
* @param boolean type, mettre vrai si on veut une barre de menu permettant l'dition des axes et echelles.
*/
public JFrame2D(boolean type)
	{
	super();
	setTitle("Opale v0.11 - JFrame 2d");
	setSize(300,300);
	super.setBackground(Color.white);

	addWindowListener(new WindowAdapter()
		{
		public void windowClosing(WindowEvent evt)
			{
			dispose();
			}
		}
		);
if(type)
 {
 menuBar1 = new JMenuBar();
 menuFile = new JMenu();
 menuFileExit = new JMenuItem();
 menuFileClose = new JMenuItem();
 menuEdition = new JMenu();
 menuEditEchelle = new JMenuItem();	
    menuFile.setText("Fichier");
    menuFileClose.setText("Fermer");
    menuFileClose.addActionListener(new ActionListener()  {

      public void actionPerformed(ActionEvent e) {
        fileClose_actionPerformed(e);
      }
    });
    menuFileExit.setText("Quitter");
    menuFileExit.addActionListener(new ActionListener()  {

      public void actionPerformed(ActionEvent e) {
        fileExit_actionPerformed(e);
      }
    });

    menuEdition.setText("Edition");
    menuEditEchelle.setText("Echelle");
    menuEditEchelle.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        menuEditEchelle_actionPerformed(e);
      }
    });

    menuEditAxes.setText("Axes");
    menuEditAxes.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        menuEditAxes_actionPerformed(e);
      }
    });


    menuFile.add(menuFileClose);
    menuFile.add(menuFileExit);
    menuEdition.add(menuEditEchelle);
    menuEdition.add(menuEditAxes);
    menuBar1.add(menuFile);
    menuBar1.add(menuEdition);
    this.setJMenuBar(menuBar1);
  }
	vue = new LinLinCS(OIJ.OIJ_ABSOLUTE,0,0,300,300);
	axes = new GAxis2D(vue); axes.drawLabel(false);
	((InfoAxis) axes.getInfo()).setTick(0,1,0,1);
	
	pack = new Pack2D();
	pack.add(OIJ.OIJ_ABSOLUTE,"oij_abs");
	getContentPane().add(new DrawPanel(),"Center");	
		
	}
	
/**
* Renvoie la rfrence  l'instance de Pack2D contenu dans l'objet courant Frame2D.
* @return Pack2D, l'instance de Pack2D.
*/
public Pack2D getPack2D()
	{
	return pack;
	}

/**
* Renvoie la rfrence  l'instance de GAxis2D contenu dans l'objet courant JFrame2D.
* @return GAxis2D, l'instance de GAxis2D.
*/
public GAxis2D getAxis()
	{
	return axes;
	}
	
/**
* Renvoie la rfrence au systme de coordonnes contenu dans l'objet courant JFrame2D.
* @return CoordSystem, l'instance de CoordSystem.
*/
public CoordSystem getCS()
	{
	return vue;
	}

class DrawPanel extends JPanel
{

DrawPanel()
	{
	super.setBackground(Color.white);
	vue.setSize(20,20,this.getWidth()-40,this.getHeight()-40);
	this.addComponentListener(new ComponentAdapter()
		{
		public void componentResized(ComponentEvent e)
			{
			vue.setSize(20,20,DrawPanel.this.getWidth()-40,DrawPanel.this.getHeight()-40);
			vue.autoadjust();
			DrawPanel.this.repaint();
			}
		});

	}

public void paintComponent(Graphics g)
	{
	super.paintComponent(g);
	g.drawRect(5,5,this.getWidth()-10,this.getHeight()-10);
	Pen2D c = new Pen2D(g,vue);
	axes.draw(c);
	c.clip();
	pack.draw(c);
	}
	
}

  //Opration Fichier | Quitter effectue
private   void fileClose_actionPerformed(ActionEvent e) {
    dispose();
  }
private   void fileExit_actionPerformed(ActionEvent e) {
    System.exit(0);
  }
private   void menuEditEchelle_actionPerformed(ActionEvent e) { 
  	ScaleEditor ech = new ScaleEditor(this);
	ech.show();
	
	}

private  void menuEditAxes_actionPerformed(ActionEvent e) { 
  	AxesEditor ed = new AxesEditor(this);
	ed.show();
	
	}



public static void main(String[] arg)
	{
	JFrame2D f =new JFrame2D(true);
	OIJ repere = new OIJ();
	f.getPack2D().add(repere,"repere");
	f.show();
	}
	
}






