#!/bin/sh
# Compiles all files.
# NOTE : It is possible to use a script more light with the command 'find ... -exec javac ... ' but the result will be slower !! 


if [ -z "$OPALE_DIR" ]
then
	echo "OPALE_DIR not initialized !"
	exit -1
fi
if [ -z "$JC" ]
then
JC='jikes -encoding iso-8859-1 -nowarn'  #Jikes 
#JC=javac # or javac (Sun, Ibm, Blackdown ...)
fi

echo "The compiler is " $JC
echo "OPALE DIRECTORY : " $OPALE_DIR

$JC  $OPALE_DIR/opale/*.java
#Compilation de opale/tools
echo "building opale.tools"
$JC  $OPALE_DIR/opale/tools/*.java

#Compilation de opale/swools
echo "building opale.swools"
$JC  $OPALE_DIR/opale/swools/*.java

#Compilation de opale/mathtools
echo "building opale.mathtools"
$JC  $OPALE_DIR/opale/mathtools/*.java

#Compilation de opale/matrix
echo "building opale.matrix"
$JC  $OPALE_DIR/opale/matrix/*.java
$JC  $OPALE_DIR/opale/matrix/solver/*.java

#Compilation de opale/ode
echo "building opale.ode"
$JC  $OPALE_DIR/opale/ode/*.java
$JC  $OPALE_DIR/opale/ode/scheme/*.java

#Compilation de opale/m2d
echo "building opale.m2d"
$JC $OPALE_DIR/opale/m2d/*.java
$JC $OPALE_DIR/opale/m2d/object2d/*.java
$JC $OPALE_DIR/opale/m2d/component2d/*.java
