import opale.tools.*;
import opale.mathtools.*;
import opale.ode.ker.*;
import opale.ode.scheme.*;

public class ex1D1
	{
	public static void main(String[] arg)
	{
	Problem pb = new Problem();	// dclaration du problme
	ExplicitEuler ts = new ExplicitEuler();	//  le schma en temps
	DVect cd = new DVect(1);	// la condition initiale

	// resolution de y'=2*ty*y, y(0)=1 (sol exacte 1/(1-t*t))
	pb.setEqn(	// on attache l'quation au problme
		new Equation()
			{
			DVect y = new DVect(1);
			public int dim() { return 1; }
			public DVect derivs(double t, DVect x)
				{
				y.set(0,2*t*x.get(0)*x.get(0));
				return y;
				}
			}
		);
	
	cd.set(0,1);	// on dfinit la condition initiale
	ts.setNstep(5000);	// le nb de pas de temps
	ts.set(0,0.9);	// le domaine d'tude
	pb.setTS(ts); // on accroche le schma en temps au problme
	pb.setInit(cd); // on accroche la condition initiale au problme
	pb.solve();	// on rsoud !
	
	try
	{
	WFile wf = new WFile("resu1d1.txt");	// on postraite dans un fichier
	pb.writeSol(wf);	// on y crit la solution
	wf.writeln("");
	wf.close();
	}
	catch(java.io.IOException e) {}	
	}
}
