import opale.tools.*;
import opale.mathtools.*;
import opale.ode.ker.*;
import opale.ode.scheme.*;
import opale.m2d.ker.*;
import opale.m2d.object2d.*;
import opale.m2d.component2d.*;

public class VanDerPol
	{
	public static void main(String[] arg)	
	{
	// Rsolution des problmes de Van der Pol avec 15 conditions initiales diffrentes

	Problem pb = new Problem(2);	//problme en dimension 2
	RK ts = new RK();		// avec la mthode de Runge Kutta classique
	
	DVect cd = new DVect(2);	// vecteur pour la condition initiale
	
	ts.setNstep(1000);		//nombre de pas en temps : 1000
	ts.set(0,10);			// tude sur l'intervalle en temps (0;10)
	pb.setEqn(			//on dfinit l'equation du systme 
		new Equation()
			{
			DVect y = new DVect(2);
			public int dim() { return 2; }
			public DVect derivs(double t, DVect x)
				{
				y.set(0,x.get(1)-x.get(0)*x.get(0)*x.get(0)+x.get(0));		//x'(t,x,y) = y-x*x+x
				y.set(1,-x.get(0));				//y'(t,x,y) = -x
				return y;
				}
			}
		);

	pb.setTS(ts);	//on associe le schma en temps
	
	// on rsoud le systme de Vander Pol avec les 15 conditions initiales diffrentes 
	double[][][] sol = new double[15][3][1000];
	int i;
	for (i=0;i<5;i++)
		{
		cd.set(0,5);	// cd intiale
		cd.set(1,-3+i);
		pb.setInit(cd);
		pb.solve();	// rsolution
		sol[i]=pb.toTab();	// on stocke la solution 
		}
	for (i=5;i<10;i++)
		{
		cd.set(0,-5);	// cd intiale
		cd.set(1,i-5);
		pb.setInit(cd);
		pb.solve();	// rsolution
		sol[i]=pb.toTab();	// on stocke la solution 
		}
	for (i=10;i<15;i++)
		{
		cd.set(0,0.1*Math.cos(i));	// cd intiale
		cd.set(1,0.1*Math.sin(i));
		pb.setInit(cd);
		pb.solve();	// rsolution
		sol[i]=pb.toTab();	// on stocke la solution 
		}
		
		
// A chaque fois, la solution du problme i est stocke dans la variable sol[i]
	
	// On affiche le rsultat avec le module 2d d'Opale
	JFrame2D jf = new JFrame2D();	// ouverture d'une JFrame2D
	jf.setTitle("Systme de Van der Pol - Opale-ODE 0.1"); // le titre
	jf.setSize(600,600); // taille intiale de la fen\^etre
	jf.getAxis().drawScale(false); // pas d'chelles sur les axes.
	OIJ repere = new OIJ();	// le repre du dessin
	jf.getCS().set(-6,6,-6,6);	//les coordonnes min/max
	jf.getPack2D().add(repere,"repere");
	GData2D[] gsol = new GData2D[15];	// les quinze objets 
	//chaque solution est reprsente par un objet de type GData2D (nuage de points)
	
	//affichage des 15 solutions
	for (i=0;i<15;i++)
		{
		gsol[i] = new GData2D(repere);	//cration de l'objet
		gsol[i].set(1000,sol[i][1],sol[i][2]);	
		jf.getPack2D().add(gsol[i],"sol"+i);	// ajout dans un Pack2D
		}
	jf.show();	//affichage  l'cran
	}

}
