package opale.tools;
/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


/**
* This class offers methods to read/write on standard out and error out.
* @author O.C.
* @since Opale-Tools 0.12
*/
public class Stdio
{
private final static boolean COUNT=false;
private static  long cpt;
private static java.io.DataInputStream in;

static 
	{
	in = new java.io.DataInputStream(System.in);
	}
	
/**
* Print a string on standard output.
* @param String s, a string
*/
public static  void print(String s)
	{
	System.out.print(s);
	}

/**
* Print a string on standard output and terminate the line.
* @param String s, a string
*/
public static  void println(String s)
	{
	System.out.println(s);
	}

/**
* Print a string on standard error output.
* @param String s, a string
*/
public static  void printerr(String s)
	{
	System.err.print(s);
	}

/**
* Print a string on standard error output and terminate the line.
* @param String s, a string
*/
public static  void printerrln(String s)
	{
	System.err.println(s);
	}


/**
* Reads a string on standard input.
* @return String, a string
*/
public static String input() throws java.io.IOException
	{
	return in.readLine();
	}


public static void main(String[] arg) throws java.io.IOException
	{
	Stdio.print("kjsdjkfhsdjk");
	Stdio.println("   kjsdjkfhsdjk");
	String s = Stdio.input();
	Stdio.println(s);
	}

}



