/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.mathtools;

/**
* This class represents a Polynom with real coefficients. The storage of coefficients is full storage, i.e. all the coefficients are stored.
* @author O.C.
* @date 03/2001
* @since Opale-Mathtools 0.13
* @see <code>PolynomModel</code>
*/
public final class Polynomial 
{
private int deg;	//the degree
private double[] coeff;	// the coeff

/**
* Constructs a polynom of degree n initialized to zero. 
* @param int n, the degree
*/
public Polynomial(int n)
	{
	construct(n);
	} 

/**
* Constructs a polynom of degree n, with the coefficients in the array tab. 
* @param int n, the degree
* @param double[] tab, the array of coefficients
*/
public Polynomial(int n, double[] tab)
	{
	construct(n,tab);
	} 

/**
* Constructs a polynom of degree n initialized to zero. 
* @param int n, the degree
*/
public void construct(int n)
	{
	deg = n >= 0 ? n : -n;
	coeff = new double[deg+1];
	for(n=0;n<=deg;n++) coeff[n]=0.;
	} 

/**
* Constructs a polynom of degree n, with the coefficients in the array tab. 
* @param int n, the degree
* @param double[] tab, the array of coefficients
*/
public void construct(int n, double[] tab)
	{
	deg = n >= 0 ? n : -n;
	coeff = new double[deg+1];
	for(n=0;n<=deg;n++) coeff[n]=tab[n];
	} 

/**
* Returns the coefficient 'i'.
* @param int i, the coefficient to get
* @return double, the value of the coefficient
*/
public double get(int i)
	{
	return coeff[i];
	}

/**
* Sets the coefficient i with the value x.
* @param int i, the coefficient to set
* @param double x, the value
*/

public void set(int i, double x)
	{
	coeff[i] = x;
	}

/**
* Return the degree.
* @return int, the degree
*/
public int deg() { return deg; }



/**
* Evaluates the polynom at the point x by the Horner's method.
* @param double x, the point x
* @return double, the value of the polynom
*/
public double eval(double x)
	{
	double y=coeff[deg];
	for(int i=deg-1;i>=0;i--)
		y=y*x+coeff[i];

	/*int j; 	// second version
	double y=coeff[j= deg];
	while (j>0)	y=y*x+coeff[--j];*/

	return y;
	}
/**
* Generic mthod to print the polynom.
*/
public String toString()
	{
	String s=""+get(0);
	
	for(int i=1;i<=deg();i++)
		s+=(get(i)>0 ? " + "+get(i) : " - "+(-get(i)))+"X^"+i;
	return s;
	}

public static void main(String[] arfg)
	{
	Polynomial p = new Polynomial(2);
	p.set(0,1);
	p.set(1,-2);
	p.set(2,-4);
	System.out.println(p.deg());
	System.out.println(p);
	System.out.println(p.eval(2));
	}
	
	
	

}
