/*
Copyright (C) 2000  Groupe Opale

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d.object2d;
import opale.tools.*;
import opale.mathtools.*;
import opale.m2d.*;
import java.util.Vector;
import java.io.StreamTokenizer;
/**
* Cette classe reprsente une conique dans le plan, d'excentricit e,
* @since Opale-2d 0.11
* @author O.C.
*/

public class Conic extends Object2D implements Cloneable
{
protected double e,p,theta0;
//protected double tinf, tsup;
protected int N;

/**
* Constructeur par dfaut.
*/
public Conic()
	{
	super();
	if (Debug.On) Debug.print("Dans Conic()");
	N=100;
	e=1;
	p=1;
	theta0=0;
//	tinf =-java.lang.Math.PI;
//	tsup = java.lang.Math.PI;
	}

/**
* Construit et initialise la conique en tant que parabole.
* @param OIJ rep, le repre.
*/
public Conic(OIJ rep)
	{
	super(rep);
	N=100;
	e=1;
	p=1;
	theta0=0;
//	tinf =-java.lang.Math.PI;
//	tsup = java.lang.Math.PI;
	}


/**
* Le constructeur de coPIe
* @param Conic d, l'objet  copier.
*/
public Conic(Conic f)
	{
        super(f.getOIJ());
	N = f.N;
//	tinf=f.tinf;
//	tsup=f.tsup;
	e=f.e;
	p=f.p;
	theta0=f.theta0;
	}

/**
* Renvoie la valeur de la fonction r(x) en un point.
* @aparam double x, le point  calculer.
*/
/*
public double val(double x)
	{
	Matrix2D mv = new Matrix2D();
	oij.matPassage(getOIJ(),mv);
	double[] p = mv.compute(x,0);
	x = p[0];
	if ( fromString)
		{
		try
		{
		double resu = parser.getResult(x);
		getOIJ().matPassage(oij,mv);
		p = mv.compute(x,resu);
		return p[1];
		}
		catch (Exception e)
		{
		System.err.println(e);
		System.err.println("Ne devrait jamais arriver");
		}
		return 0;
		}
	else
		{
		double resu = fonc.val(x);
		getOIJ().matPassage(oij,mv);
		p = mv.compute(x,resu);
		return p[1];
		}
	}
*/

/**
* Fixe les bornes de dfinition.
* @param double inf, sup, les bornes du domaine de dfinition.
*/
/*public void set(double inf, double sup)
	{
	if ( inf > sup )
		{
		tsup = inf;
		tinf = sup;
		}
	else
		{
		tsup = sup;
		tinf = inf;
		}
	}
*/

/**
* Fixe le nombre de points de prcision.
* @param int n, le nombre de points.
*/
public void set(int n)
	{
	N = java.lang.Math.max(2,n); 
	}

/**
* Fixe l'excentricit, l'inclinaison et le paramtre de la conique.
* @param double e, l'excentricit.
* @param double p, le paramtre.
* @param double t0, l'inclinaison en radians.
*/
public void setParams(double e, double p, double t0)
	{
	if (e>0) this.e = e; 
	this.p = p;
	theta0 = t0 % (2*java.lang.Math.PI);
	}
	
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	Conic y = (Conic) super.clone();
	return y;
	}

/**
* Effectue un changement de repere de l'objet. Pas encore disponible
* @param OIJ rep, le nouveau repere.
*/
public void changeOIJ(OIJ rep)
	{
	}
	
public void writeFileMore(WFile f, Pack2D p)
	{
	int i;
	f.writeln("N "+N);
//	f.writeln("Tmin "+tinf);
//	f.writeln("Tmax "+tsup);
	f.writeln("e "+e);
	f.writeln("p "+this.p);
	f.writeln("theta0 "+theta0);
	
	}	
	
public int readKeyWord(String word, RFile f, Pack2D p)  throws java.io.IOException, MalformedFileException
	{
	int type,i;
	if ( word.equals("N"))
		{
		type = f.nextToken();
		N = (int) f.nval;
		return 0;
		}
/*	else if ( word.equals("Tmin"))
		{
		type = f.nextToken();
		if (type != StreamTokenizer.TT_NUMBER) return -1;
		tinf = f.nval;
		return 0;
		}
	else if ( word.equals("Tmax"))
		{
		type = f.nextToken();
		if (type != StreamTokenizer.TT_NUMBER) return -1;
		tsup = f.nval;
		return 0;
		}*/
	else if ( word.equals("e"))
		{
		type = f.nextToken();
		if (type != StreamTokenizer.TT_NUMBER) return -1;
		if (e>0) e = f.nval;
		else throw new MalformedFileException("L'e'xcentricit doit tre strictement positive. Impossible de construire la conique "+this);
		return 0;
		}
	else if ( word.equals("p"))
		{
		type = f.nextToken();
		if (type != StreamTokenizer.TT_NUMBER) return -1;
		this.p = f.nval;
		return 0;
		}
	else if ( word.equals("theta0"))
		{
		type = f.nextToken();
		if (type != StreamTokenizer.TT_NUMBER) return -1;
		theta0 = f.nval % (2*java.lang.Math.PI);
		return 0;
		}
		
	return -1;
		
	}
	
public String toString()
	{
	String s="r(t) = "+p+"/(1 + "+e+"cos(t - "+theta0+")";
	return s;
	}
	
public static void main(String[] arg)
	{
	System.out.println((-5.) % 2);
	}	
}
