package opale.tools;
/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


/**
* Cette classe permet simplement d'ecrire sur la sortie err en prfixant chaque sortie par le mot 'Debug i' ou i est le nombre d'appel effectu depuis le dbut du programme. Cette classe existe dans un but de simplification de dboggage dans la phase de dveloppement (on isole les ecritures 'normales' du programme des critures destines au dboggage et on bnficie d'une numrotation automatique des affichages).
* @author O.C.
* @since Opale-Tools 0.11
*/
public class Debug
{
/**
* On = true for the debug mode.
*/
public final static boolean On = false;
static private long cpt;

/**
* Ecrit la chaine passe en paramtre.
* @param String s, la chaine  crire.
*/
public static void print(String s)
	{
	System.err.println("Debug::"+(cpt++)+") "+s);
	}
/**
* Ecrit l'objet pass en paramtre sur la sortie erreur en le prcdant de la chaine passe galement en paramtre.
* @param String s, la chaine  crire.
* @param Object obj, l'objet  afficher.
*/
public static void print(String s, Object obj)
	{
	System.err.println("Debug::"+(cpt++)+") "+s+obj);
	}

/**
* Ecrit l'entier pass en paramtre sur la sortie erreur en le prcdant de la chaine passe galement en paramtre.
* @param String s, la chaine  crire.
* @param int obj, l'entier  afficher.
*/
public static void print(String s, int i)
	{
	System.err.println("Debug::"+(cpt++)+") "+s+i);
	}


/**
* Ecrit l'entier long pass en paramtre sur la sortie erreur en le prcdant de la chaine passe galement en paramtre.
* @param String s, la chaine  crire.
* @param long i, l'entier  afficher.
*/
public static void print(String s, long i)
	{
	System.err.println("Debug::"+(cpt++)+") "+s+i);
	}


/**
* Ecrit le rel pass en paramtre sur la sortie erreur en le prcdant de la chaine passe galement en paramtre.
* @param String s, la chaine  crire.
* @param float i, le rel  afficher.
*/
public static void print(String s, float i)
	{
	System.err.println("Debug::"+(cpt++)+") "+s+i);
	}


/**
* Ecrit le double pass en paramtre sur la sortie erreur en le prcdant de la chaine passe galement en paramtre.
* @param String s, la chaine  crire.
* @param double i, le double  afficher.
*/
public static void print(String s, double i)
	{
	System.err.println("Debug::"+(cpt++)+") "+s+i);
	}


/**
* Ecrit le caractre pass en paramtre sur la sortie erreur en le prcdant de la chaine passe galement en paramtre.
* @param String s, la chaine  crire.
* @param char i, le caractre  afficher.
*/
public static void print(String s, char i)
	{
	System.err.println("Debug::"+(cpt++)+") "+s+i);
	}

/**
* Ecrit le boolean pass en paramtre sur la sortie erreur en le prcdant de la chaine passe galement en paramtre.
* @param String s, la chaine  crire.
* @param bolean i, le boolean  afficher.
*/
public static void print(String s, boolean i)
	{
	System.err.println("Debug::"+(cpt++)+") "+s+i);
	}

/**
* Verify an assertion.
* @param boolean, an assert.
*/
public static void assert(boolean i)
	{
	if (!i) throw new IllegalArgumentException("an assertion failed !!");
	}

public static void main(String[] arg)
	{
	int i=10;
	Debug.print("soo",10.2);
	Debug.print("soo",i);
	Debug.assert(1==0);
	}
}
