package opale.ode.scheme;

import opale.mathtools.*;
import opale.ode.ker.*;


/**
* Cette classe implmente le schma de Runge Kutta classique qui consiste  avancer en temps de la facon suivante : ***.
* @author O.C.
* @since Opale-ODE 0.1
*/
public final class RK extends TimeScheme
{
/**
* Cette mthode dfinit l'avanc en temps par la formule de Runge Kutta classique.
*/	
public void forward(Equation eq)
	{
	double[] tempo = new double[present().size()];
	int i;
	double dt2 = 0.5*dt();

	double[] der = eq.derivs(time(),present().toArray());
	for (i=0;i<present().size();i++)
		tempo[i]=present().get(i)+dt2*der[i];

	double[] der2 = eq.derivs(time()+dt2,tempo);
	for (i=0;i<present().size();i++)
		tempo[i]=present().get(i)+dt2*der2[i];
	
	double[] der3 = eq.derivs(time()+dt2,tempo);
	for (i=0;i<present().size();i++)
		tempo[i]=present().get(i)+dt()*der3[i];
	double[] der4 = eq.derivs(time()+dt(),tempo);
	
	
	for (i=0;i<present().size();i++)
		{
		present().set(i,present().get(i)+dt()*((der[i]+der4[i])/6+(der2[i]+der3[i])/3));
		}
	}

public String toString()
	{
	return "RK";
	}

}
