package opale.ode.scheme;

import opale.mathtools.*;
import opale.ode.ker.*;


/**
* Cette classe implmente le schma d'Heun.
* @author O.C.
* @since Opale-ODE 0.1
*/
public final class Heun extends TimeScheme
{
private double temp;
/**
* Cette mthode dfinit l'avanc en temps par la formule de Heun.
*/	
public void forward(Equation eq)
	{
	double[] present = new double[present().size()];
	int i;
	double[] der = eq.derivs(time(),present().toArray());
	for (i=0;i<present().size();i++)
		present[i]=present().get(i)+dt()*der[i];
	double[] der2 = eq.derivs(time()+dt(),present);
	for (i=0;i<present().size();i++)
		{
		present().set(i,present().get(i)+0.5*dt()*(der[i]+der2[i]));

		}
	}

public String toString()
	{
	return "Heun";
	}

}
