package opale.ode.ker;

import opale.tools.*;
import java.io.*;


/**
* Class abstraite qui sert  dsigner un objet comme appartenant  la famille 'ODE' : plus prcisement assure qu' une classe drive instanciable possde des mthodes de sauvegarde/relecvture dans un fichier au format .ode (voir documentation).
* @author O.C.
* @since Opale-ODE 0.1
*/ 
public abstract class ObjectODE 
{
/**
* Cette mthode permet de lire des donnes dans un fichier au format .ode. Elle appele la mthodes abstraite readKeyword qui doit tre codes dans les classes filles.
* @param RFile f, le fichier  lire.
* @param ODE od, dsigne le 'paquet' d'objet de type ObjectODE dans lequel on va stocker les informations lues.
*/
public void readFile( RFile f,ODE ode) throws java.io.IOException,MalformedFileException
	{
	int type;
	type = f.nextToken();	//on lit la premiere '{'
	if ( (type !=StreamTokenizer.TT_WORD) || !f.sval.equals("{") ) throw new MalformedFileException("Fichier de donnes au mauvais format !!");
	type = f.nextToken();	
	do
		{
		if (type != StreamTokenizer.TT_WORD)  throw new MalformedFileException("Fichier de donnes au mauvais format : on attend un mot cl !!");
		if (readKeyWord(f.sval,f,ode) == -1) throw new MalformedFileException("Fichier de donnes au mauvais format : erreur de lecture d'un mot cl !!");
		type = f.nextToken();
		}
	while ((type !=StreamTokenizer.TT_WORD) || !f.sval.equals("}") );
	
	}
	
/**
* Mthode abstraite permettant la relecture d'un mot cl dans un fichier .ode.
* @param String s, le mot cl  lire.
* @param RFile f, le fichier de lecture.
* @param ODE ode,  dsigne le 'paquet' d'objet de type ObjectODE dans lequel on va stocker les informations lues.
@return int, 0 si le mot cl est reconnu, -1 sinon.
*/
public abstract int readKeyWord(String s, RFile f,ODE ode) throws java.io.IOException, MalformedFileException; 

/**
* Mthode abstraite qui permet d'ecrire les donnes relatives  l'objet courant dans un fichier.
* @param WFile f, le fichier d'ecriture.
* @param ODE ode,   dsigne le 'paquet' d'objet de type ObjectODE contenant les informations  stocker.
*/
public abstract void writeFile(WFile f, ODE ode) throws MalformedFileException;
}
