/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.mathtools;

/**
* This class represents a Polynom with real coefficients. The coefficients are coded by a subclass of <code>PolynomModel</code>. 
* @author O.C.
* @date 02/2001
* @since Opale-Mathtools 0.11
* @see <code>PolynomModel</code>
*/
public class Polynom
{
private int deg;	//the degree
private PolynomModel coeff;	// the coeff

/**
* Constructs a polynom of degree n, with the coefficients in the array tab. The storage of coefficients is <code>ClassicPolynomModel</code>, i.e. all the coefficients are stored.
* @param int n, the degree
* @param double[] tab, the array of coefficients
*/
public Polynom(int n, double[] tab)
	{
	deg = n >= 0 ? n : -n;
	coeff = new ClassicPolynomModel(n+1);
	for(n=0;n<=deg;n++) coeff.set(n,tab[n]);
	} 

/**
* Evaluates the polynom at the point x.
* @param double x, the point x
* @return double, the value of the polynom
*/
public double compute(double x)
	{
	int i;
	double y=0.;
	
	for(i=0;i<=deg;i++)
		y+=coeff.get(i)*Math.pow(x,i);
	return y;
	}


}
