/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.mathtools;

/**
* Cette classe reprsente un nombre complexe et propose des oprations algbriques sur ceux ci.
* @since Opale-Mathtools 0.1
* @author O.C.
*/

public class DComplex implements  Cloneable
{
private double x,y;	//les composantes du nombre
private static DComplex i = new DComplex(0,1);
public DComplex(){}	//constructeur par defaut x = y = 0


/**
* Constructeur avec les composantes pour arguments.
* @param double x, y les composantes du nombre complexe.
*/
public DComplex(double x, double y)
	{
	this.x = x;
	this.y = y;
	}

/**
* Constructeur de copie.
* @param DComplex, le complexe  copier.
*/
public DComplex(DComplex z)
	{
	this.x = z.x;
	this.y = z.y;
	}

/**
* Additionne le nombre complexe pass en argument.
* @param DComplex z, le nombre a additioner.
*/ 
public final void add(DComplex z)
	{
	this.x+=z.x;
	this.y+=z.y;
	}

/**
* Soustrait le nombre complexe pass en argument.
* @param DComplex z, le nombre a soustraire.
*/ 
public final void sub(DComplex z)
	{
	this.x-=z.x;
	this.y-=z.y;
	}

/**
* Multiplie le nombre complexe pass en argument.
* @param DComplex z, le nombre a multiplier.
*/ 
public final void mul(DComplex z)
	{
	double temp = this.x;
	this.x=this.x*z.x - this.y*z.y;
	this.y=this.y*z.x + temp*z.y; 
	}

/**
* Retourne le nombre complexe i.
* @return DComplex, le nombre i.
*/
public static DComplex i()
	{
	return i;
	}

/** 
* Retourne la composante rlle x du nombre complexe.
* @return double, la composante relle.
*/
public final double getRe()
	{
	return x;
	}

/** 
* Retourne la composante imaginaire y du nombre complexe.
* @return double, la composante imaginaire.
*/
public final double getIm()
	{
	return y;
	}

/**
* Fixe la composante relle x.
* @param double x, la nouvelle composante.
*/
public final void setRe(double x)
	{
	this.x = x;
	}

/**
* Fixe la composante imaginaire y.
* @param double y, la nouvelle composante.
*/
public final void setIm(double y)
	{
	this.y = y;
	}

/**
* Fixe les composantes.
* @param double x, double y, les composantes.
*/
public final void set(double x, double y)
	{
	this.x = x;
	this.y = y;
	}

/**
* Fixe les composantes.
* @param DComplex z, le complexe a recopier.
*/
public final void set(DComplex z)
	{
	this.x = z.x;
	this.y = z.y;
	}

/**
* Renvoie le module du nombre.
* @return double, la norme.
*/
public final double norm()
	{
	return Math.sqrt(normSq());
	}
	
/**
* Renvoie le carr du module du nombre.
* @return double, le carr du module.
*/
public final double normSq()
	{
	return x*x + y*y;
	}
	
/**
*  Returns a string representation of this complex number.
* @return String
*/
public String toString()
	{
	return x+((y<0) ? "-i*" : "+i*")+Math.abs(y);
	}	

/**
* Cette mthode teste si le nombre est gal  un objet pass en argument.
* @param Object obj un objet  comparer avec le nombre.
* @return <code>true</code> si l'objet  comparer est une instance de DComplex et
est gal au nombre courant; <code>false</code> sinon.
*/
public boolean equals(Object obj)
	{
	if (obj instanceof DComplex)
		{
        	DComplex p = (DComplex) obj;
		return (x == p.x) && (y == p.y);
        	}
    	return false;
    }


/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	try
		{
		DComplex p = (DComplex) super.clone();
		p.x = x;
		p.y = y;
		return p;
		}
	catch (CloneNotSupportedException e) // ne devrait jamais arriver
		{
		throw new InternalError();
		}
   	}

	
public static void main(String[] arg)
	{
	DComplex a= new DComplex(1,-3);
	System.err.println(a);
	a.mul(DComplex.i());
	System.err.println(a);
	System.err.println(a.equals(new DComplex(3,1)));
	}
	

}

