/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d.object2d;
import opale.m2d.ker.*;
import opale.tools.*;
import opale.mathtools.*;

/**
* Cette classe tend <code>Conic</code> et reprsente graphiquement une conique plane.
* @since Opale-2d 0.11
* @author O.C.
*/

public class GConic extends Conic implements Cloneable, GObject2D
{
private InfoObject info; 


/**
* Constructeur par dfaut.
*/
public GConic()
	{
	super();
	if (Debug.On) Debug.print("Dans GConic()");
	info = new InfoObject();
	}

/**
* Construit et initialise la fonction avec les informations par dfaut.  
* @param OIJ rep, le repre.
*/
public GConic(OIJ rep)
	{
	super(rep);
	info = new InfoObject();
	}


/**
* Le constructeur de copie
* @param GConic d, l'objet  copier.
*/
public GConic(GConic f)
	{
	super(f);	
	info = f.info;
	}

public void draw(Pen2D c)
	{

	if ( info.isVisible())
		{
	c.setColor(info.getColor());
	double tinf,tsup,x0,y0,x1,y1;
	if (e==1)
		{
		tinf = theta0-Math.PI+1e-6;
		tsup = theta0+Math.PI-1.e-6;
		}		
	else 
		{
		tinf = theta0-Math.PI;
		tsup = theta0+Math.PI;
		}

	int i;
	double pas = Math.abs(tsup-tinf)/(N-1);
	double temp,th;
	
	temp = p/(1+e*Math.cos(tinf-theta0));
	x0 = temp * Math.cos(tinf);
	y0 = temp * Math.sin(tinf);
	for (i=1;i<N;i++)
		{
		th = tinf + i*pas;
		temp = p/(1+e*Math.cos(th-theta0));
		x1 = temp * Math.cos(th);
		y1 = temp*Math.sin(th);
		c.drawLine(x0,y0,x1,y1);
		x0=x1;
		y0=y1;
		}
	
	}


	}
	
	
	
public InfoObject getInfo()
	{
	return info;
	}
	
public int readKeyWord(String word, RFile f, Pack2D p) throws java.io.IOException, MalformedFileException
	{
	if ( word.equals("INFO"))
		{
		info.readFile(f,p);
		return 0;
		}
	else return super.readKeyWord(word,f,p);
	}

public void writeFileMore(WFile f, Pack2D p)
	{
	info.writeFile(f,p);
	super.writeFileMore(f,p);
	}	

	
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	GConic gy = (GConic) super.clone();
	return gy;
	}

}
