/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d.ker;
import opale.tools.*;
import java.io.*;

/**
* Classe contenant des informations sur les objets de type <code>Point2D</code>. Elle tend la classe <code>InfoObjet</code> et renseigne donc sur les champs contenus dans cette dernire.
* @author O.C.
* @since Opale-2d 0.1
*/
public class InfoPoint extends InfoObject implements Cloneable
{
//membres privs
protected int symbol;	//la forme du point
protected int size;	//la taille en pixel du point
protected int fill;	//remplissage des points

//les constructeurs publiques
/**
* Constructeur par dfaut: symbol = 0; size = 1;
*/
public InfoPoint()
	{
	super();
	symbol = 0;
	size = 1;
	fill = 0;
	}

/**
* Le constructeur de copie
* @param InfoPoint inf, l'information  copier
*/
public InfoPoint(InfoPoint inf)
	{
	super(inf);
	symbol = inf.getSymbol();
	size = inf.getSize();
	fill = inf.getFill();
	}


//methodes d'accs, publiques

/**
* Renvoie l'entier dfinissant la forme du point
* @return int, la forme du point 
* 0 = point
* 1 = +
* 2 = X
* 3 = cercle
* 4 = carr
* 5 = diamant
* 6 = triangle haut
* 7 = triangle bas
* 8 = triangle gauche
* 9 = triangle droit
*/
public int getSymbol()
	{
	return symbol;
	}

/**
* change la forme du point
* @param int, la nouvelle forme
*/
public void setSymbol(int sym)
	{
	symbol = sym;
	}

/**
* Renvoie la taille en pixel du point
* @return int, la taille 
*/
public int getSize()
	{
	return size;
	}

/**
* change la taille du point
* @param int size, la nouvelle taille en pixel
*/
public void setSize(int size)
	{
	this.size = size;
	}

/**
* Renvoie le mode de remplissage du point
* @return int, la taille
* 0 = aucun
* 1 = plein
* 2 = opaque 
*/
public int getFill()
	{
	return fill;
	}

/**
* change le mode de remplissage du point
* @param int fill, le nouveau mode de remplissage
*/
public void setFill(int fill)
	{
	this.fill = fill;
	}

/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	try
	{
	return (InfoPoint) super.clone();
    }
	catch(InternalError e)
	{
	throw e;
	}
	}

public void writeFileMore(WFile f, Pack2D p)
	{
	f.writeln("\tSYMBOL " +symbol);
	f.writeln("\tSIZE " +size);
	}	
	
public int readKeyWord(String word, RFile f, Pack2D p) throws java.io.IOException, MalformedFileException
	{
	int type;
	if ( word.equals("SYMBOL"))
		{
		type = f.nextToken();
		if (type != StreamTokenizer.TT_NUMBER) return -1;
		symbol = (int) f.nval;
		return 0;
		}
	else if ( word.equals("SIZE"))
		{
		type = f.nextToken();
		if (type != StreamTokenizer.TT_NUMBER) return -1;
		size = (int) f.nval;
		return 0;
		}
	return -1;
		
	}
		
}
