/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d.ker;
import java.awt.Color;
import opale.tools.*;
import java.io.*;


/**
* Cette classe contient les informations obligatoires que doit renseign  toute instance d'une classe implmentant l'interface <codeGObject2D</code>.
Dans cette interface on trouve a cet effet la mthode <code>InfoObjet getInfo()</code> qui doit etre obligatoirement dfinit dans les classes filles.
* Il sera possible, conseill voire indispensable de driver cette classe <code>InfoObjet</code> pour des objets gomtriques ncessitant plus d'informations. 
* @author O.C.
* @since Opale-2d 0.1
*/

public class InfoObject implements Cloneable
{
//les membres privs
private String name;
private Color color;
private boolean visible;

/**
* Le constructeur par dfaut
*/
public InfoObject()
	{
	color = Color.black;
	name = new String("Sans nom");
	visible = true;
	}

/**
* Le constructeur de copie
* @param InfoObjet, l'instance  copier
*/
public InfoObject(InfoObject inf)
	{
	color = inf.getColor();
	name = new String(inf.getName());
	visible = inf.isVisible();
	}

/**
* Lit dans un fichier les donnes relatives aux informations d'un objet graphique en invoquant la mthode
readKeyWord()
* @param RFile f, le fichier  lire.
* @prama Pack2D p, le pack2D qui contient les objets courants.
*/
public void readFile(RFile f,Pack2D pack) throws java.io.IOException,MalformedFileException
	{
	int type;

	type = f.nextToken();	//on lit la premiere '{'
	if ((type !=StreamTokenizer.TT_WORD) || !f.sval.equals("{") ) throw new MalformedFileException("Fichier de donnes au mauvais format !!");
	type = f.nextToken();	
	do
		{
		if ((f.sval).equals("NAME"))
			{
			type =f.nextToken();
			if (type != StreamTokenizer.TT_WORD) throw new MalformedFileException("Fichier de donnes au mauvais format : erreur  la lecture du nom d'un objet graphique");
			name = f.sval;
			} 
		else if ((f.sval).equals("COLOR"))
			{
			type =f.nextToken();
			if (type != StreamTokenizer.TT_NUMBER) throw new MalformedFileException("Erreur  la lecture de la couleur d'un objet graphique : on attendait les valeurs R G B");
			int r = (int) f.nval;
			type =f.nextToken();
			if (type != StreamTokenizer.TT_NUMBER) throw new MalformedFileException("Erreur  la lecture de la couleur d'un objet graphique : on attendait les valeurs R G B");
			int g = (int) f.nval;
			type =f.nextToken();
			if (type != StreamTokenizer.TT_NUMBER) throw new MalformedFileException("Erreur  la lecture de la couleur d'un objet graphique : on attendait les valeurs R G B");
			int b = (int) f.nval;
			color = new Color(r,g,b);

/*			setColor((Color) Class.forName("java.awt.Color").getField(f.sval).get(null));
			
			catch(java.lang.ClassNotFoundException e)
			{//ne doit jamais arriver !!
			}
			catch(java.lang.NoSuchFieldException e)
			{
			throw new MalformedFileException("Fichier de donnes au mauvais format : erreur  la lecture de la couleur d'un objet graphique");
			}
			catch(java.lang.IllegalAccessException e)
			{//ne devrait pas arriver
		 	}*/
			} 
		else if ((f.sval).equals("VISIBLE"))
			{
			type =f.nextToken();
			if (type != StreamTokenizer.TT_WORD) throw new MalformedFileException("Fichier de donnes au mauvais format : erreur  la lecture de la visibilit d'un objet graphique");
			if (f.sval.equals("YES")) setVisible();
			else if (f.sval.equals("NO")) setUnvisible();
			else throw new MalformedFileException("Fichier de donnes au mauvais format : erreur  la lecture de la visibilit d'un objet graphique. On attendait YES ou NO");
			} 
			
		else if (readKeyWord(f.sval,f,pack) == -1) throw new MalformedFileException("Fichier de donnes au mauvais format : erreur de lecture d'un mot cl !!");
		type = f.nextToken();
		}
	while ((type !=StreamTokenizer.TT_WORD) || !f.sval.equals("}") );
	
	}

/**
* Interprte un mot cl lu dans un fichier.
* @param String word, le mot cl  dcoder.
* @param RFile f, le fichier en cours de lecture.
* @param Pack2D p, le pack qui contient l'ensemble des objets 2d en cours
d'existence.
* @return int, 0 si le mot  t compris, -1 sinon.
*/
public int readKeyWord(String word, RFile f,Pack2D pack) throws java.io.IOException, MalformedFileException
	{
	return -1;
	} 

/**
* Ecrit les informations concernant l'objet dans un fichier.
* @param WFile f, le fichier dans lequel il faut crire.
*/
public void writeFile(WFile f,Pack2D pack) 
	{
	f.writeln("INFO");
	f.writeln("\t{");
	f.writeln("\tNAME " +name);
	f.writeln("\tCOLOR " +color.getRed()+" " +color.getGreen()+" "+color.getBlue());
	if (visible==false)
		f.writeln("\tVISIBLE NO");
	writeFileMore(f,pack);
	f.writeln("\t}");
	}

/**
* Ecris les informations complmentaires concernant l'objet dans un fichier.
* @param WFile f, le fichier dans lequel il faut crire.
*/
public void writeFileMore(WFile f,Pack2D pack) {}

//les methodes d'acces publiques

/**
* Renvoie le nom de l'instance
* @return String nom, nom de l'instance
*/
public String getName()
	{
	return name;
	}

/**
* Change le nom de l'instance
* @param String nom, le nouveau nom
*/
public void setName(String nom)
	{
	name = new String(nom);
	}


/**
* Renvoie la couleur de trac
* @return Color, la couleur
*/
public Color getColor()
	{
	return color;
	}

/**
* Change la couleur du trac
* @param Color color, la nouvelle couleur
*/
public void setColor(Color color)
	{
	this.color = color;
	}

/**
* Precise si l'objet est visible ou pas
* @return boolean, true si l'objet est visible, false sinon
*/
public boolean isVisible()
	{
	return visible;
	}

/**
* Rend visible l'objet
*/
public void setVisible()
	{
	visible = true;
	}

/**
* Rend invisible l'objet
*/
public void setUnvisible()
	{
	visible = false;
	}

/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	try
		{
		return (InfoObject) super.clone();
		}
	catch (CloneNotSupportedException e) // ne devrait jamais arriver
		{
	    throw new InternalError();
		}
    }

}
