package opale.m2d.component2d;

/**
 * Titre : <p>
 * Description : <p>
 * Copyright : Copyright (c) Olivier Cioni<p>
 * Socit : <p>
 * @author Olivier Cioni
 * @version 1.0
 */

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import opale.m2d.ker.GAxis2D;
import opale.swools.*;

class AxesEditor extends JFrame {
private JFrame2D mere;
  BorderLayout borderLayout1 = new BorderLayout();
  JPanel jPanel1 = new JPanel();
  BorderLayout borderLayout2 = new BorderLayout();
  JPanel jPanel2 = new JPanel();
  JButton okButton = new JButton();
  JButton appButton = new JButton();
  JButton closeButton = new JButton();
  JPanel jPanel3 = new JPanel();
  GridLayout gridLayout1 = new GridLayout();
  JPanel jPanel4 = new JPanel();
  JPanel jPanel5 = new JPanel();
  JPanel jPanel6 = new JPanel();
  JPanel jPanel7 = new JPanel();
  JPanel jPanel8 = new JPanel();
  FlowLayout flowLayout1 = new FlowLayout();
  JLabel xminLabel = new JLabel();
  DoubleTextField xminField;
  JLabel xmaxLabel = new JLabel();
  DoubleTextField xmaxField;
  JLabel ymin = new JLabel();
  DoubleTextField yminField;
  JLabel ymax = new JLabel();
  DoubleTextField ymaxField;
  JCheckBox visibleCheck = new JCheckBox();
  JCheckBox numCheck = new JCheckBox();

  public AxesEditor(JFrame2D mere) {
    this.mere = mere;
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    this.setSize(new Dimension(300, 300));
    setResizable(false);
    setTitle("Axes");
    this.getContentPane().setLayout(borderLayout1);
    jPanel1.setLayout(borderLayout2);
    okButton.setText("Ok");
    okButton.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        okButton_actionPerformed(e);
      }
    });
    appButton.setText("Appliquer");
    appButton.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        appButton_actionPerformed(e);
      }
    });
    closeButton.setText("Fermer");
    closeButton.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        closeButton_actionPerformed(e);
      }
    });
    opale.m2d.ker.InfoAxis info = (opale.m2d.ker.InfoAxis) mere.getAxis().getInfo();
    xminField = new DoubleTextField(info.getXtickMin(),10);
    xmaxField = new DoubleTextField(info.getXtickMax(),10);
    yminField = new DoubleTextField(info.getYtickMin(),10);
    ymaxField = new DoubleTextField(info.getYtickMax(),10);
    
    jPanel3.setLayout(gridLayout1);
    gridLayout1.setRows(5);
    jPanel4.setLayout(flowLayout1);
    xminLabel.setFont(new java.awt.Font("Monospaced", 1, 12));
    xminLabel.setText("espacement x min = ");
    xmaxLabel.setFont(new java.awt.Font("Monospaced", 1, 12));
    xmaxLabel.setText("espacement x max = ");
    ymin.setFont(new java.awt.Font("Monospaced", 1, 12));
    ymin.setText("espacement y min = ");
    ymax.setFont(new java.awt.Font("Monospaced", 1, 12));
    ymax.setText("espacement y max = ");
    visibleCheck.setText("afficher axes");
    visibleCheck.setSelected(mere.getAxis().getInfo().isVisible());
    numCheck.setText("afficher echelle");
    numCheck.setSelected(mere.getAxis().printScale());
    this.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    this.getContentPane().add(jPanel1, BorderLayout.CENTER);
    jPanel1.add(jPanel2, BorderLayout.SOUTH);
    jPanel2.add(okButton, null);
    jPanel2.add(appButton, null);
    jPanel2.add(closeButton, null);
    jPanel1.add(jPanel3, BorderLayout.CENTER);
    jPanel3.add(jPanel4, null);
    jPanel4.add(xminLabel, null);
    jPanel4.add(xminField, null);
    jPanel3.add(jPanel5, null);
    jPanel5.add(xmaxLabel, null);
    jPanel5.add(xmaxField, null);
    jPanel3.add(jPanel6, null);
    jPanel6.add(ymin, null);
    jPanel6.add(yminField, null);
    jPanel3.add(jPanel7, null);
    jPanel7.add(ymax, null);
    jPanel7.add(ymaxField, null);
    jPanel3.add(jPanel8, null);
    jPanel8.add(visibleCheck, null);
    jPanel8.add(numCheck, null);
  }

  void okButton_actionPerformed(ActionEvent e) {

    opale.m2d.ker.InfoAxis info = (opale.m2d.ker.InfoAxis) mere.getAxis().getInfo();
   info.setTick(xminField.getValue(),xmaxField.getValue(),yminField.getValue(),ymaxField.getValue());
   if (visibleCheck.isSelected()) info.setVisible();
   else info.setUnvisible();
   if (numCheck.isSelected()) mere.getAxis().drawScale(true);
   else mere.getAxis().drawScale(false);
   mere.repaint();
  dispose();
  }

  void appButton_actionPerformed(ActionEvent e) {
    opale.m2d.ker.InfoAxis info = (opale.m2d.ker.InfoAxis) mere.getAxis().getInfo();
   info.setTick(xminField.getValue(),xmaxField.getValue(),yminField.getValue(),ymaxField.getValue());
   if (visibleCheck.isSelected()) info.setVisible();
   else info.setUnvisible();
   if (numCheck.isSelected()) mere.getAxis().drawScale(true);
   else mere.getAxis().drawScale(false);
   mere.repaint();
  }

  void closeButton_actionPerformed(ActionEvent e) {
 dispose();

  }

}
