/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d.object2d;

import java.io.IOException;
import opale.m2d.ker.Matrix2D;
import opale.m2d.ker.OIJ;
import opale.m2d.ker.OIJException;
import opale.m2d.ker.Object2D;
import opale.m2d.ker.Pack2D;
import opale.mathtools.IyFx;
import opale.mathtools.ParseFunction;
import opale.tools.MalformedFileException;
import opale.tools.RFile;
import opale.tools.WFile;

public class FPolar
extends Object2D
implements Cloneable {
    private IyFx fonc;
    private String sf = "";
    private boolean fromString = false;
    private ParseFunction parser;
    private OIJ oij;
    protected double tinf;
    protected double tsup;
    protected int N;

    public FPolar() {
        this.oij = new OIJ();
        System.out.println("Dans FPolar()");
        this.parser = new ParseFunction();
        this.N = 100;
        this.tinf = 0.0;
        this.tsup = 6.28;
        this.fonc = new IyFx(){

            public double val(double d) {
                return 0.0;
            }
        };
    }

    public FPolar(OIJ oIJ) {
        super(oIJ);
        this.oij = oIJ;
        this.parser = new ParseFunction();
        this.N = 100;
        this.tinf = 0.0;
        this.tsup = 6.28;
        this.fonc = new IyFx(){

            public double val(double d) {
                return 0.0;
            }
        };
    }

    public FPolar(FPolar fPolar) {
        super(fPolar.getOIJ());
        this.oij = fPolar.oij;
        this.fromString = fPolar.fromString;
        if (this.fromString) {
            this.sf = fPolar.sf;
            this.parser = new ParseFunction();
            if (!this.parser.parse(this.sf)) {
                System.err.println("Probl\u00e8me dans FPolar(FPolar f) : Ne devrait jamais arriver !!");
                System.err.println("Contactez l'\u00e9quipe opale par  email cioni@eleves.enpc.fr en pr\u00e9cisant les circonstances d'apparition du bug.");
                System.exit(-1);
            }
        } else {
            this.fonc = fPolar.fonc;
        }
        this.N = fPolar.N;
        this.tinf = fPolar.tinf;
        this.tsup = fPolar.tsup;
    }

    public double val(double d) {
        Matrix2D matrix2D = new Matrix2D();
        this.oij.matPassage(this.getOIJ(), matrix2D);
        double[] dArray = matrix2D.compute(d, 0.0);
        d = dArray[0];
        if (this.fromString) {
            try {
                double d2 = this.parser.getResult(d);
                this.getOIJ().matPassage(this.oij, matrix2D);
                dArray = matrix2D.compute(d, d2);
                return dArray[1];
            }
            catch (Exception exception) {
                System.err.println(exception);
                System.err.println("Ne devrait jamais arriver");
                return 0.0;
            }
        }
        double d3 = this.fonc.val(d);
        this.getOIJ().matPassage(this.oij, matrix2D);
        dArray = matrix2D.compute(d, d3);
        return dArray[1];
    }

    public void set(IyFx iyFx, double d, double d2, int n) {
        this.N = Math.max(2, n);
        this.fromString = false;
        this.fonc = iyFx;
        if (d > d2) {
            this.tsup = d;
            this.tinf = d2;
        } else {
            this.tsup = d2;
            this.tinf = d;
        }
    }

    public void set(IyFx iyFx, String string, double d, double d2, int n) {
        this.sf = string;
        this.N = Math.max(2, n);
        this.fromString = false;
        this.fonc = iyFx;
        if (d > d2) {
            this.tsup = d;
            this.tinf = d2;
        } else {
            this.tsup = d2;
            this.tinf = d;
        }
    }

    public void set(double d, double d2) {
        if (d > d2) {
            this.tsup = d;
            this.tinf = d2;
        } else {
            this.tsup = d2;
            this.tinf = d;
        }
    }

    public void set(int n) {
        this.N = Math.max(2, n);
    }

    public void set(IyFx iyFx) {
        this.fromString = false;
        this.fonc = iyFx;
    }

    public void set(IyFx iyFx, String string) {
        this.sf = string;
        this.fromString = false;
        this.fonc = iyFx;
    }

    public boolean set(String string) {
        if (this.parser.parse(string)) {
            boolean[] blArray = this.parser.getVariables();
            if (blArray[1] || blArray[2]) {
                return false;
            }
            this.fromString = true;
            this.sf = string;
            return true;
        }
        return false;
    }

    public Object clone() {
        FPolar fPolar = (FPolar)super.clone();
        fPolar.oij = this.oij;
        fPolar.parser = new ParseFunction();
        if (this.fromString) {
            fPolar.parser.parse(this.sf);
        }
        return fPolar;
    }

    public void changeOIJ(OIJ oIJ) {
        this.oij = oIJ;
    }

    public void writeFileMore(WFile wFile, Pack2D pack2D) {
        wFile.writeln("N " + this.N);
        wFile.writeln("Tmin " + this.tinf);
        wFile.writeln("Tmax " + this.tsup);
        wFile.writeln("f(x)=  " + this.sf);
    }

    public int readKeyWord(String string, RFile rFile, Pack2D pack2D) throws IOException, MalformedFileException {
        if (string.equals("N")) {
            int n = rFile.nextToken();
            this.N = (int)rFile.nval;
            return 0;
        }
        if (string.equals("f(x)=")) {
            int n = rFile.nextToken();
            if (!rFile.sval.endsWith("'") || !rFile.sval.startsWith("'")) {
                throw new MalformedFileException("Erreur \u00e0 la lecture de la fonction \u00e0 tracer : " + rFile.sval + ". La fonction \u00e0 tracer doit etre indiqu\u00e9 entre guillemets");
            }
            String string2 = rFile.sval.substring(1, rFile.sval.length() - 1);
            if (!this.set(string2)) {
                throw new MalformedFileException("Erreur \u00e0 la lecture de la fonction \u00e0 tracer : " + string2);
            }
            return 0;
        }
        if (string.equals("Tmin")) {
            int n = rFile.nextToken();
            if (n != -2) {
                return -1;
            }
            this.tinf = rFile.nval;
            return 0;
        }
        if (string.equals("Tmax")) {
            int n = rFile.nextToken();
            if (n != -2) {
                return -1;
            }
            this.tsup = rFile.nval;
            return 0;
        }
        return -1;
    }

    public String toString() {
        String string = "r(t) = " + this.sf;
        return string;
    }

    public static void main(String[] stringArray) {
        OIJ oIJ = new OIJ();
        FPolar fPolar = new FPolar(oIJ);
        try {
            OIJ oIJ2 = new OIJ(oIJ, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0);
            fPolar.changeOIJ(oIJ2);
            fPolar.set(new IyFx(){

                public double val(double d) {
                    return (d - 1.0) * (d - 1.0);
                }
            }, "(x-1)*(x-1)");
            System.err.println(fPolar.val(0.0));
        }
        catch (OIJException oIJException) {
            // empty catch block
        }
    }
}

