package opale.swools;
/**
* La classe DoubleTextField tend <code>JTextField</code> et ne permet que la saisie de double.
* @version 1 janvier 2000 
* @author O.C.
*/

import javax.swing.*;
import javax.swing.text.*;

class DoubleTextDocument extends PlainDocument
{  public void insertString(int offs, String str, 
      AttributeSet a) 
      throws BadLocationException 
   {  if (str == null) return;
      String oldString = getText(0, getLength());
      String newString = oldString.substring(0, offs)
         + str + oldString.substring(offs);
      try
      {  Double.parseDouble(newString + "0");
         super.insertString(offs, str, a);
      }
      catch(NumberFormatException e)
      {  
      }
   }
}

public class DoubleTextField extends JTextField 
{  public DoubleTextField(double defval, int size)
   {  super("" + defval, size);
   }

   protected Document createDefaultModel() 
   {  return new DoubleTextDocument();
   }

   public boolean isValid()
   {  try
      {  Double.parseDouble(getText());
         return true;
      }
      catch(NumberFormatException e)
      {  return false; 
      }
   }

   public double getValue()
   {  try
      {  return Double.parseDouble(getText());
      }
      catch(NumberFormatException e)
      {  return 0; 
      }
   }
}