/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.util;

/**
 * Interface for objects that have a name.
 * 
 * @author Artiste on the Web
 */

public interface NamedObject {
  /**
   * Gets the name of this object.
   * @return the name
   */
  public String getName();
  /**
   * Cheks if this object has a name. An object is considered as having a name if its name
   * property is non-nul and has a length > 0.
   * @return true if this object is named
   */
  public boolean hasName();
  /**
   * Sets the name of this object.
   * @param name the new name
   */
  public void setName(String name);
}
