/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.util;

/**
 * Objects that implement this interface can be lock; if they are, they will no longer be
 * refreshed or rebuilt.
 *
 * It can result in a significant speed boost.
 *
 * @author Artiste on the Web
 */

public interface Lockable {
  /**
   * Locks this object.
   * Notice that locking is cumulative : if you lock twice an object, you need to unlock it
   * twice before it can be refreshed or rebuilt.
   * The lock-state is not saved in serialization.
   */
  public void lock();
  /**
   * Unlocks this object.
   * Unlocking has no effect on an unlocked object.
   * Notice that locking is cumulative : if you lock twice an object, you need to unlock it twice before it can be refreshed or rebuilt.
   * The lock-state is not saved in serialization.
   */
  public void unlock();
  /**
   * Checks the lock state of this object.
   * @return true if this object is locked.
   */
  public boolean isLocked();
}

