/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.util;

import java.io.*;
import java.beans.*;

/**
 * Abstract implementation of a bean object, that can fire property chang event. Even if i
 * use this class as a "bean class", you should never consider that all beans extends this
 * class !
 * 
 * Notice than the listeners collection is not serialized.
 * 
 * @author Artiste on the Web
 */

public interface Bean extends Serializable, Cloneable {
  /**
   * Clones this bean. Warning : the listeners are not cloned. The clone has no listener.
   * @return a clone
   */
  public Object clone();
  
  /**
   * Gets all the listeners for property change event.
   * @return the collection of listener.
   */
  public java.util.Collection propertyChangeListeners();
  
  /**
   * Adds a listener for property change event.
   * @param listener the listener.
   */
  public void addPropertyChangeListener   (PropertyChangeListener l);
  /**
   * Removes a listener for property change event.
   * @param listener the listener.
   */
  public void removePropertyChangeListener(PropertyChangeListener l);
  
  /**
   * Fires a property change event on this bean, with no other information.
   */
  public void firePropertyChange();
  /**
   * Fires a property change event on this bean, for the given property.
   * @param propertyName the name of the changed property
   */
  public void firePropertyChange(String propertyName);
  /**
   * Fires a property change event on this bean, for the given property.
   * @param propertyName the name of the property that have changed.
   * @param oldValue the old value of the property, or null.
   * @param newValue the new value of the property, or null.
   */
  public void firePropertyChange(String propertyName, Object oldValue, Object newValue);
  }

