/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.util;

import java.io.*;
import java.util.Vector;
import java.util.Iterator;

/**
 * An implementation of the soya.util.Collection interface. It is built over java.util.Vector .
 * 
 * @author Artiste on the Web
 */

public class Bag extends Object implements opale.soya.util.Collection, Serializable {
  protected final java.util.Collection c = new Vector();

  public boolean add(Object o) {
    boolean b = c.add(o);
    if(b) fireAdd(o);
    return b;
  }
  public boolean remove(Object o) {
    boolean b = c.remove(o);
    if(b) fireRemove(o);
    return b;
  }
  public boolean addAll(java.util.Collection col) {
    boolean b = c.addAll(col);
    if(b) {
      for(Iterator i = col.iterator(); i.hasNext(); ) fireAdd(i.next());
    }
    return b;
  }
  public void clear() {
    java.util.Collection s = new Vector(c.size());
    s.addAll(c);
    c.clear();
    for(Iterator i = s.iterator(); i.hasNext(); ) fireRemove(i.next());
  }
  public boolean contains(Object o) { return c.contains(o); }
  public boolean containsAll(java.util.Collection col) { return c.containsAll(col); }
  public boolean isEmpty() { return c.isEmpty(); }
  public Iterator iterator() { return c.iterator(); }
  public Iterator iteratorRecursive() { return new Collection.RecursiveIterator(c.iterator()); }
  public Iterator iterator(Class clazz) { return new Collection.ClassSpecificIterator(this, clazz); }
  public Iterator iteratorRecursive(Class clazz) { return new Collection.ClassSpecificIterator(iteratorRecursive(), clazz); }
  public boolean removeAll(java.util.Collection col) {
    boolean b = c.removeAll(col);
    if(b) {
      for(Iterator i = col.iterator(); i.hasNext(); ) fireRemove(i.next());
    }
    return b;
  }
  public boolean retainAll(java.util.Collection col) {
    java.util.Collection s = new Vector(col.size());
    for(Iterator i = col.iterator(); i.hasNext(); ) {
      Object o = i.next();
      if(c.contains(o)) s.add(o);
    }
    boolean b = c.retainAll(col);
    for(Iterator i = s.iterator(); i.hasNext(); ) fireRemove(i.next());
    return b;
  }
  public int size() { return c.size(); }
  public Object[] toArray() { return c.toArray(); }
  public Object[] toArray(Object[] a) { return c.toArray(a); }

  // Collection events :
  protected transient java.util.Collection collectionListeners;
  public java.util.Collection collectionListeners() { return collectionListeners; }
  public void addCollectionListener (CollectionListener l) {
    if(collectionListeners == null) collectionListeners = new java.util.Vector();
    synchronized(collectionListeners) { collectionListeners.add(l); }
  }
  public void removeCollectionListener (CollectionListener l) {
    if(collectionListeners != null) {
      synchronized(collectionListeners) { collectionListeners.remove(l); }
    }
  }
  public void fireAdd(Object element) {
    if(isWorthFiringCollectionEvent()) {
      AddEvent e = new AddEvent(this, element);
      int size;
      Object[] ls;
      synchronized (collectionListeners) {
        size = collectionListeners.size();
        ls = collectionListeners.toArray();
      }
      for (int i = 0; i < size; i++) ((CollectionListener) ls[i]).added(e);
    }
  }
  public void fireRemove(Object element) {
    if(isWorthFiringCollectionEvent()) {
      RemoveEvent e = new RemoveEvent(this, element);
      int size;
      Object[] ls;
      synchronized (collectionListeners) {
        size = collectionListeners.size();
        ls = collectionListeners.toArray();
      }
      for (int i = 0; i < size; i++) ((CollectionListener) ls[i]).removed(e);
    }
  }
  protected boolean isWorthFiringCollectionEvent() {
    return (collectionListeners != null) && (!collectionListeners.isEmpty());
  }
}
