/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.util;

/**
 * Class for add event, raised when an element is added to the collection.
 * 
 * @author Artiste on the Web
 */

public class AddEvent extends CollectionEvent {
  /**
   * Create a CollectionAddEvent.
   * @param s the source of the event.
   * @param e the added element.
   */
  public AddEvent(Object s, Object e) {
    super(s);
    element = e;
  }

  private Object element;
  /**
   * Used to recover witch element was added.
   * @return the added element.
   */
  public Object getElement() {return element; }
}

