/*
 * Soya3D tutorial
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
Lesson 7 : Events
Now that you know the basic of events, you'll learn how to receive more complex events from
world : add/remove event and sub-event.
*/

package opale.soya.tutorial;

/*
First, import a few packages.
*/
import opale.soya.*;                    // contains the basic stuff (Initialization,...).
import opale.soya.util.*;               // contains utilitary stuff (Collection,...).
import opale.soya.soya3d.*;             // contains the 3D stuff (A lot of things).
import opale.soya.soya3d.event.*;       // contains the event stuff.
import opale.soya.soya3d.model.*;       // contains the modeling stuff (Shape,...).

import java.beans.*;

/*
The Lesson7 draw nothing at the screen !
*/
public class Lesson7 {
  public static void main(String[] args) {
    /*
    No initialization is required, because we don't render 3D !
    */
    
    Shape.path = (new Lesson6()).getClass().getResource("").getFile();
    Shape shape = null;
    try { shape = Shape.get("test"); }
    catch(Exception e) { e.printStackTrace(); }
    
    /*
    Creates the scene.
    */
    World3D scene = new World3D();
    scene.setName("scene"); // Names it.
    
    /*
    Creates a CollectionListener that will be used to receive add/remove-events from the scene
    object.
    A CollectionListener is a listener that receive event from an opale.soya.util.Collection
    object. The opale.soya.util.Collection interface extends java.util.Collection with events
    support.
    A world implements the opale.soya.util.Collection interface, so we can use
    CollectionListener here.
    */
    CollectionListener collectionListenerToScene = new CollectionListener() {
      public void added(AddEvent e) {
        /*
        The getElement() method of the AddEvent object returns the added element; the
        getSource() method return the Collection that has sent the event.
        Here, we use the name property of the 3D elements to identify them.
        */
        System.out.println("  " + ((Element3D) e.getElement()).getName() + " has been added in "     + ((Element3D) e.getSource()).getName());
      }
      public void removed(RemoveEvent e) {
        /*
        The getElement() method of the RemoveEvent object returns the removed element; the
        getSource() method return the Collection that has sent the event.
        */
        System.out.println("  " + ((Element3D) e.getElement()).getName() + " has been removed from " + ((Element3D) e.getSource()).getName());
      }
    };
    
    /*
    Creates a PropertyChangeListener that will be used to receive sub-event from the scene
    object.
    A sub-event is an event generated by an element in the world, and not by the world itself.
    */
    PropertyChangeListener subListenerToScene = new PropertyChangeListener() {
      public void propertyChange(PropertyChangeEvent e) {
        /*
        Prints the name of the changed property and the name of the changed object.
        */
        System.out.println("  the " + e.getPropertyName() + " property of " + ((Element3D) e.getSource()).getName() + " has changed !");
        /*
        Prints if the object has been moved, roted or resized. If so, the PropertyChangeEvent object
        is an instance of the MoveEvent, OrientateEvent or ResizeEvent interface.
        */
        if(e instanceof MoveEvent     ) System.out.println("  ...the object has been moved !"  );
        if(e instanceof OrientateEvent) System.out.println("  ...the object has been roted !"  );
        if(e instanceof ResizeEvent   ) System.out.println("  ...the object has been resized !");
      }
    };
    
    /*
    Registers the collection listener.
    */
    scene.addCollectionListener          (collectionListenerToScene);
    
    /*
    Registers the sub collection listener. This listener receive add/remove-events from any
    worlds that are inside scene.
    */
    scene.addSubCollectionListener       (collectionListenerToScene);
    
    /*
    Registers the sub listener.
    */
    scene.addSubPropertyChangeListener   (subListenerToScene       );
    
    /*
    Now, let's add and remove element in the scene, modify their property
    and see what's happen !
    */
    /*
    Creates and adds a volume called "volume1".
    */
    System.out.println("We are adding volume1 in the scene...");
    Volume3D volume1 = new Volume3D("volume1");
    scene.add(volume1);
    
    /*
    Moves volume1.
    */
    System.out.println("We are moving volume1...");
    volume1.move(1f, 0f, 0f); 
    
    /*
    Removes volume1.
    */
    System.out.println("We are removing volume1 from the scene...");
    scene.remove(volume1);
    
    /*
    Creates and adds a world called "world1".
    */
    System.out.println("We are adding world1 in the scene...");
    World3D  world1  = new World3D ("world1" );
    scene.add(world1);
    
    /*
    Creates and adds in world1 a volume called "volume2".
    */
    System.out.println("We are adding volume2 in world1...");
    Volume3D volume2 = new Volume3D("volume2");
    volume2.setShape(shape);
    world1.add(volume2);
    
    /*
    Rotates volume2.
    */
    System.out.println("We are rotating volume2...");
    volume2.rotateLateral(90f); 
  }
}
