/*
 * Soya3D tutorial
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
Lesson 5 : hierarchy
In this lesson, we'll build a 3D solar system. To keep things easy, we'll limit the demo to
a sun, a planet and a moon.

The sun is a world with a sun-like shape, and it contains the planet.
The planet is a world with a planet-like shape, and it contains the moon.
The moon is just a volume, with a moon-like shape. (moon-like and NOT doom-like :-)

When we rotate the sun, the planet is moved, because it is INSIDE the sun world, and the moon
is also moved, because it is inside the planet that is inside the sun.

When we rotate the planet, the moon is moved, because it is inside the planet world.

You can compare worlds to usefull box that can contains others elements. Moving, rotating,
resizing the box will affects all the elements in the box.
*/

package opale.soya.tutorial;

import opale.soya.*;                    // contains the basic stuff (initialization,...).
import opale.soya.awt.*;                // contains the GUI stuff (RenderingCanvas, RenderingFrame,...).
import opale.soya.soya2d.*;             // contains the 2D stuff (Texturing and Material).
import opale.soya.soya3d.*;             // contains the 3D stuff (A lot of things).
import opale.soya.soya3d.model.*;       // contains the modeling stuff (Shape,...).
import opale.soya.soya3d.geometry.*;    // contains the geometric stuff (Sphere3D,...).

/*
The Lesson5 is a rendering frame.
*/
public class Lesson5 extends RenderingFrame {
  public static void main(String[] args) { (new Lesson5()).setVisible(true); }
  
  public Lesson5() {
    super(320, 200);
    Soya.init(this);
    
    scene = new Environment3D();
    scene.setAmbientColor(.5f, .5f, .5f);
    
    Shape.path = getClass().getResource("").getFile();
    
    /*
    Create the sun.
    */
    World3D sun = new World3D();
    try { sun.setShape(Shape.get("sun")); }
    catch(Exception e) { e.printStackTrace(); }
    scene.add(sun);
    
    /*
    Create the planet.
    */
    World3D planet = new World3D();
    try { planet.setShape(Shape.get("planet")); }
    catch(Exception e) { e.printStackTrace(); }
    sun.add(planet);
    planet.move(0f, 0f, 3f);
    
    /*
    Create the moon.
    */
    Volume3D moon = new Volume3D();
    try { moon.setShape(Shape.get("moon")); }
    catch(Exception e) { e.printStackTrace(); }
    planet.add(moon);
    moon.move(0f, 0f, 2f);
    
    Camera3D camera = new Camera3D();
    scene.add(camera);
    camera.move(0f, -1f, 7f);
    
    this.setRenderer(camera);
    
    while(true) {
      sun   .rotateLateral(10f);
      planet.rotateLateral(10f);
      moon  .rotateLateral(10f);
      render();
    }
  }
  private Environment3D scene;
}
/*
In this lesson, we build a complex hierarchy of worlds. Such a hierarchy is possible because
a world can contains as many elements as you want, including other worlds ! There is no limits
to the number of worlds.

Hierarchy stuff :
The Element3D class has lots of usefull methods to control the world's hierarchy :
  - getParent() return the world that contains the element (or null if there is no parent).
  - getRootParent() return the root parent of the element (or null if there is no root parent)
      The root parent is a world that has no parent and that contains the element, or its
      parent or its parent's parent...
      Here,
      moon.getRootParent() == planet.getRootParent() == sun.getRootParent() == scene
  - getEnvironment() return the first parent of the element that is an instance of
      Environment3D.
  - isInside(World3D) return true if the element is inside the given world. For example, here,
      moon  .isInside(planet) == true
      moon  .isInside(sun   ) == true
      planet.isInside(sun   ) == true
      planet.isInside(moon  ) == false
*/
