/*
 * Soya3D tutorial
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
Lesson 102 : Particle system strikes again !
*/

package opale.soya.tutorial;

/*
First, import a few soya packages.
*/
import opale.soya.*;                    // contains the basic stuff (initialization,...).
import opale.soya.awt.*;                // contains the GUI stuff (RenderingCanvas, RenderingFrame,...).
import opale.soya.soya2d.*;             // contains the 2D stuff (Texturing and Material).
import opale.soya.soya3d.*;             // contains the 3D stuff (A lot of things).
import opale.soya.soya3d.model.*;       // contains the modeling stuff, for the cube (Shape,...).
import opale.soya.soya3d.fx.*;          // contains the special effect stuff.
import opale.soya.soya3d.fx.particle.*; // contains the particle system stuff (ParticleBunch3D,...).

import java.net.*;

/*
The Lesson102 is a rendering frame.
*/
public class Lesson102 extends RenderingFrame {
  /*
  Create a Lesson102 object and show it.
  */
  public static void main(String[] args) {
    (new Lesson102()).setVisible(true);
  }
  
  /*
  Builds the scene.
  */
  public Lesson102() {
    super(320, 200);
    /*
    inits.
    */
    Soya.init(this);
    Shape   .path = getClass().getResource("").getFile();
    Material.path = getClass().getResource("").getFile();
    
    /*
    Creates the scene (here an environment).
    */
    scene = new Environment3D();
    scene.setAmbientColor(.5f, .5f, .5f);
    
    /*
    Creates a light.
    */
    Light3D light = new Light3D();
    light.setColor(1f, .8f, .2f);
    light.move(0f, .5f, 0f);
    light.setAttenuation(0f, .01f, 0f);
    scene.add(light);
    
    /*
    Creates a camera.
    */
    Camera3D camera = new Camera3D();
    scene.add(camera);
    camera.move(-1f, 0f, 5f);
    
    
    Material material = null;
    try { material = Material.get("x-geser-1"); }
    catch(Exception e) { e.printStackTrace(); }
    
    
    /*
    Creates a black hole-like particles bunch.
    */
    BlackHole3D bunch = new BlackHole3D(
                                        new ParticlesLifes       (.001f, .005f                  ), // The object that will manage the particles' lifes.
                                        new FadingParticlesColors(.8f, .9f, 1f, .1f, .4f        ), // The object that will manage the particles' colors.
                                        new SpriteParticlesDrawer(material, -.5f, -.5f, .5f, .5f)  // The object that will draw the particles.
                                        );
    bunch.setNumberOfParticles(300);
    scene.add(bunch);
    
    
    this.setRenderer(camera);
    
    showFPS();
    
    while(true) {
      render();
    }
  }
  
  private Environment3D scene;
}
