/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.transformation;

import opale.soya.soya3d.*;
import opale.soya.util.*;
import java.beans.*;

/**
 * Interface for transformation objects.
 * 
 * @author Artiste on the Web
 */

public class SimpleRotation extends AbstractBean {
  public SimpleRotation() {  }
  public SimpleRotation(float angle, float axex, float axey, float axez) {
    this.angle = angle;
    axe.move(axex, axey, axez);
  }
  public SimpleRotation(float angle, float axex, float axey, float axez, CoordSyst cs) {
    this.angle = angle;
    axe.move(axex, axey, axez);
    axe.setCoordSyst(cs);
  }
  public SimpleRotation(float angle, Vector axe) {
    this.angle = angle;
    this.axe = (Vector) axe.clone();
  }
  public Object clone() { return new SimpleRotation(angle, axe); }
  
  private Vector axe = new Vector();
  {
    axe.addPropertyChangeListener(new PropertyChangeListener() {
      public void propertyChange(PropertyChangeEvent e) {
        firePropertyChange("axe");
      }
    });
  }
  public float getAxeX() { return axe.getX(); }
  public float getAxeY() { return axe.getY(); }
  public float getAxeZ() { return axe.getZ(); }
  public void setAxeX(float f) { axe.setX(f); }
  public void setAxeY(float f) { axe.setY(f); }
  public void setAxeZ(float f) { axe.setZ(f); }
  
  private float angle;
  public float getAngle() { return angle; }
  public void setAngle(float f) {
    angle = f;
    firePropertyChange("angle");
  }
  
  public float[] toMatrix() {
    return Matrix.matrixRotate(angle, axe.getX(), axe.getY(), axe.getZ());
  }
}
