/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.model;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.editor.*;
import opale.soya.soya2d.*;
import java.beans.*;
import java.io.*;

/**
 * @author Artiste on the Web
 */

public class ShapeEditor extends StoredInPathObjectEditor {
  // Overrides :
  protected StoredInPathObject getNew  () { return new FragmentedShape(); }
  protected StoredInPathObject getNamed(String name) {
    try { return Shape.get(name); }
    catch(Exception e) {
      System.out.println("Can't find shape : " + name);
      e.printStackTrace();
    }
    return getNull();
  }
  protected StoredInPathObject list() {
    try {
      String name = StoredInPathObjectChooser.question(getFrame(), Shape.path, "shape", true);
      if(name == null) return null;
      return Shape.get(name); 
    }
    catch(Exception e) { System.out.println("can't find or list shapes!"); e.printStackTrace(); }
    return null;
  }
  private java.awt.Frame getFrame() {
    java.awt.Component c = getCustomEditor();
    while(true) {
      c = c.getParent();
      if(c instanceof java.awt.Frame) return (java.awt.Frame) c;
    }
  }
  
  private String[] tags = computeTags(Shape.path, ".shape");
  public String[] getTags() { return tags; }
}
