/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.model;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.awt.*;
import opale.soya.editor.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.event.*;
import java.beans.*;
import java.util.Iterator;
import java.util.Collection;

public class PointsRegrouper implements PropertyChangeListener {
  public PointsRegrouper(Collection ps) {
    points = ps;

    useAdvancedPoint = true;
    for(Iterator i = ps.iterator(); i.hasNext(); ) {
      Object o = i.next();
      if((!(o instanceof Textured)) || (!(o instanceof Colored))) {
        useAdvancedPoint= false;
        break;
      }
    }
    Position aPoint = (Position) points.iterator().next();
    if(useAdvancedPoint) {
      AdvancedPoint ap = new AdvancedPoint();
      ap.setColor(((Colored) aPoint).getColor());
      ap.setTextureCoords(((Textured) aPoint).getTextureCoordX(), ((Textured) aPoint).getTextureCoordY());
      p = ap;
    }
    else p = new Point();
    p.move(aPoint);
    p.addPropertyChangeListener(this);
    
    for(Iterator i = points.iterator(); i.hasNext(); ) {
      Position point = (Position) i.next();
      point.addPropertyChangeListener(pcl);
    }
  }
  public void finalize() {
    for(Iterator i = points.iterator(); i.hasNext(); ) {
      Position point = (Position) i.next();
      point.removePropertyChangeListener(pcl);
    }
  }
  
  private PropertyChangeListener pcl = new PropertyChangeListener() {
    public void propertyChange(PropertyChangeEvent e) { // Assume that all points stay regrouped.
      if(computeValidity()) {
        Object o = e.getSource();
        String propName = e.getPropertyName();
        valid = false;
        if(e instanceof MoveEvent) p.move((Position) o);
        else {
          if(p instanceof AdvancedPoint) {
            if(o instanceof Textured) {
              Textured t = (Textured) o;
              ((Textured) p).setTextureCoords(t.getTextureCoordX(), t.getTextureCoordY());
            }
            if(o instanceof Colored) {
              Colored c = (Colored) o;
              ((Colored) p).setColor(c.getColor());
            }
          }
        }
        valid = true;
      }
      else valid = false;
    }
  };
  
  private Position p;
  private boolean useAdvancedPoint;
  public Object getEditable() { return p; }
  private final java.util.Collection points;
  
  private boolean valid = true;
  private synchronized boolean computeValidity() {
    Iterator i = points.iterator();
    Position point = ((Position) i.next());
    for(; i.hasNext(); ) {
      if(!i.next().equals(point)) return false; // 2 points are differents => regroupment are no longer valid.
    }
    return true; // All points are equals => valid.
  }

  public synchronized void propertyChange(PropertyChangeEvent e) {
    if(!valid) return;
    if(e instanceof MoveEvent) {
      for(Iterator i = points.iterator(); i.hasNext(); ) ((Position) i.next()).move(p);
      return;
    }
    if(e.getPropertyName().equals("color")) {
      for(Iterator i = points.iterator(); i.hasNext(); ) {
        Object o = i.next();
        if(o instanceof Colored) {
          ((Colored) o).setColor(((Colored) p).getColor()); // p is a colored because its color has changed!
        }
      }
      return;
    }
    if((e.getPropertyName().equals("textureCoordX")) || (e.getPropertyName().equals("textureCoordY"))) {
      for(Iterator i = points.iterator(); i.hasNext(); ) {
        Object o = i.next();
        if(o instanceof Textured) ((Textured) o).setTextureCoords(((Textured) p).getTextureCoordX(), ((Textured) p).getTextureCoordY()); // p is a textured because its texture coord has changed!
      }
      return;
    }
  }

  /**
   * From a collection of points, return a collection of the same points, but where identical points (=equals) have been regrouped (=replaced by another position, with which they share all changes.).
   * @param points the collection of original points
   * @return the collection of points after regroupment
   */
  public static Collection regroupPoints(Collection points) {
    Collection groups = new java.util.Vector();
    firstFor:
    for(Iterator i = points.iterator(); i.hasNext(); ) {
      Object o = i.next();
      for(Iterator j = groups.iterator(); j.hasNext(); ) {
        Collection c = (Collection) j.next();
        if(o.equals((Position) c.iterator().next())) {
          c.add(o);
          continue firstFor;
        }
      }
      Collection group = new java.util.Vector(); // New group.
      group.add(o);
      groups.add(group);
    }
    Collection regroupedPoints = new java.util.Vector();
    for(Iterator i = groups.iterator(); i.hasNext(); ) {
      Collection group = (Collection) i.next();
      if(group.size() == 1) regroupedPoints.add(group.iterator().next()); // Just one, no group needed.
      else                  regroupedPoints.add((new PointsRegrouper(group)).getEditable()); // Create a group.
    }
    return regroupedPoints;
  }
}
