/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.model;

import opale.soya.util.*;
import opale.soya.soya3d.*;
import java.util.Iterator;

/**
 * Interface for recording a point, while building smooth lit normals.
 * 
 * Usefull class for smoothLit.
 * 
 * @author Artiste on the Web
 */

public class PointRecord {
  public PointRecord(float x2, float y2, float z2) {
    x = x2;
    y = y2;
    z = z2;
  }
  public int index = -1;
  public Object data;
  public float x, y, z;
  public boolean isPointSuitable(float x2, float y2, float z2) {
    if(Matrix.pow2(x - x2) +
       Matrix.pow2(y - y2) +
       Matrix.pow2(z - z2) < 0.0001f) return true;
    else return false;
  }
  private java.util.Collection listeners; // = new java.util.Vector();
  public void addNormalComputationListener(NormalComputationListener l) {
    if(listeners == null) listeners = new java.util.Vector();
    listeners.add(l);
  }
  public void addNormalComponent(float nx2, float ny2, float nz2, float weigth) {
    nx = nx + nx2 * weigth;
    ny = ny + ny2 * weigth;
    nz = nz + nz2 * weigth;
  }
  public void computeNormal() {
    float length = (float) java.lang.Math.sqrt((double) (nx * nx + ny * ny + nz * nz));
    nx = nx / length;
    ny = ny / length;
    nz = nz / length;
    
    if(listeners !=null) {
      for(Iterator i = listeners.iterator(); i.hasNext(); )
        ((NormalComputationListener) i.next()).normalComputed(nx, ny, nz);
    }
  }
  private float nx, ny, nz;
  public interface NormalComputationListener {
    public void normalComputed(float nx, float ny, float nz);
  }
}
